/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.linux;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;

public class Linux2_6DiskProbe
extends AbstractProbe {
    private static final long serialVersionUID = 1L;
    private static final int NB_OF_RESSOURCES = 11;
    private long[] readsIssued;
    private long[] readsMerged;
    private long[] readSectors;
    private long[] readTimeInMs;
    private long[] writesIssued;
    private long[] writesMerged;
    private long[] writeSectors;
    private long[] writeTimeInMs;
    private long[] ioInProgress;
    private long[] ioInMs;
    private long[] averageIoMs;
    private RandomAccessFile diskstatsFile;
    private int nbOfDiskandParts;
    private ArrayList linesToSkip = new ArrayList();
    private ArrayList allResources = new ArrayList();

    public Linux2_6DiskProbe() throws NoResourceToProbeException {
        super("disk probe");
        ArrayList<String> diskandParts = new ArrayList<String>();
        try {
            String currentline;
            int lineNumber = 0;
            this.diskstatsFile = new RandomAccessFile("/proc/diskstats", "r");
            this.diskstatsFile.seek(0L);
            while ((currentline = this.diskstatsFile.readLine()) != null) {
                int i = 0;
                while (currentline.charAt(i) == ' ' || currentline.charAt(i) >= '0' && currentline.charAt(i) <= '9') {
                    ++i;
                }
                StringBuffer ressourceName = new StringBuffer();
                while (currentline.charAt(i) != ' ') {
                    ressourceName.append(currentline.charAt(i));
                    ++i;
                }
                while (currentline.charAt(i) == ' ') {
                    ++i;
                }
                String ressourceNameStr = ressourceName.toString();
                if ((ressourceNameStr.startsWith("sd") || ressourceNameStr.startsWith("hd")) && ressourceNameStr.charAt(2) >= 'a' && ressourceNameStr.charAt(2) <= 'd') {
                    diskandParts.add(ressourceNameStr);
                    int toSkip = 4;
                    if (ressourceNameStr.length() == 3) {
                        toSkip = 11;
                    }
                    for (int j = 0; j < toSkip; ++j) {
                        while (i < currentline.length() && currentline.charAt(i) >= '0' && currentline.charAt(i) <= '9') {
                            ++i;
                        }
                        ++i;
                    }
                    this.linesToSkip.add(new Integer(lineNumber));
                    lineNumber = 0;
                    continue;
                }
                ++lineNumber;
            }
        }
        catch (Exception e) {
            try {
                this.diskstatsFile.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            e.printStackTrace();
            throw new NoResourceToProbeException("Invalid /proc/diskstats file format for this probe.");
        }
        this.nbOfDiskandParts = diskandParts.size();
        if (this.nbOfDiskandParts == 0) {
            throw new NoResourceToProbeException();
        }
        this.readsIssued = new long[this.nbOfDiskandParts];
        this.allResources.add(this.readsIssued);
        this.readsMerged = new long[this.nbOfDiskandParts];
        this.allResources.add(this.readsMerged);
        this.readSectors = new long[this.nbOfDiskandParts];
        this.allResources.add(this.readSectors);
        this.readTimeInMs = new long[this.nbOfDiskandParts];
        this.allResources.add(this.readTimeInMs);
        this.writesIssued = new long[this.nbOfDiskandParts];
        this.allResources.add(this.writesIssued);
        this.writesMerged = new long[this.nbOfDiskandParts];
        this.allResources.add(this.writesMerged);
        this.writeSectors = new long[this.nbOfDiskandParts];
        this.allResources.add(this.writeSectors);
        this.writeTimeInMs = new long[this.nbOfDiskandParts];
        this.allResources.add(this.writeTimeInMs);
        this.ioInProgress = new long[this.nbOfDiskandParts];
        this.allResources.add(this.ioInProgress);
        this.ioInMs = new long[this.nbOfDiskandParts];
        this.allResources.add(this.ioInMs);
        this.averageIoMs = new long[this.nbOfDiskandParts];
        this.allResources.add(this.averageIoMs);
        this.resourceNames = new String[this.nbOfDiskandParts * 11];
        this.resourceIds = new int[this.resourceNames.length];
        for (int i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        for (int j = 0; j < this.nbOfDiskandParts; ++j) {
            String name = (String)diskandParts.get(j);
            this.resourceNames[j * 11] = name + " reads issued";
            this.resourceNames[j * 11 + 1] = name + " reads merged";
            this.resourceNames[j * 11 + 2] = name + " read sectors";
            this.resourceNames[j * 11 + 3] = name + " read time in ms";
            this.resourceNames[j * 11 + 4] = name + " writes issued";
            this.resourceNames[j * 11 + 5] = name + " writes merged";
            this.resourceNames[j * 11 + 6] = name + " write sectors";
            this.resourceNames[j * 11 + 7] = name + " write time in ms";
            this.resourceNames[j * 11 + 8] = name + " io in progress";
            this.resourceNames[j * 11 + 9] = name + " io in ms";
            this.resourceNames[j * 11 + 10] = name + " average io in ms";
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.diskstatsFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getDiskUsage();
        long[] result = new long[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= this.resourceNames.length) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int disk = resourceIds[i] / 11;
            result[i] = ((long[])this.allResources.get(resourceIds[i] % 11))[disk];
        }
        return result;
    }

    private void getDiskUsage() throws ProbeException {
        try {
            this.diskstatsFile.seek(0L);
            int nbLinesToSkip = 0;
            for (int currentDisk = 0; currentDisk < this.nbOfDiskandParts; ++currentDisk) {
                int foo;
                int j;
                boolean resourceIsDisk;
                nbLinesToSkip = (Integer)this.linesToSkip.get(currentDisk);
                String currentline = this.diskstatsFile.readLine();
                for (int j2 = 0; j2 < nbLinesToSkip; ++j2) {
                    currentline = this.diskstatsFile.readLine();
                }
                int i = 0;
                while (currentline.charAt(i) == ' ') {
                    ++i;
                }
                while (currentline.charAt(i) == ' ' || currentline.charAt(i) >= '0' && currentline.charAt(i) <= '9') {
                    ++i;
                }
                boolean bl = resourceIsDisk = currentline.charAt(i + 3) == ' ';
                while (currentline.charAt(i) != ' ') {
                    ++i;
                }
                while (currentline.charAt(i) == ' ') {
                    ++i;
                }
                if (!resourceIsDisk) {
                    for (j = 0; j < 11; ++j) {
                        ((long[])this.allResources.get((int)j))[currentDisk] = 0L;
                    }
                    block15: for (j = 0; j < 4; ++j) {
                        foo = 0;
                        while (i < currentline.length() && currentline.charAt(i) >= '0' && currentline.charAt(i) <= '9') {
                            foo = foo * 10 + currentline.charAt(i) - 48;
                            ++i;
                        }
                        ++i;
                        switch (j) {
                            case 0: {
                                this.readsIssued[currentDisk] = foo;
                                continue block15;
                            }
                            case 1: {
                                this.readSectors[currentDisk] = foo;
                                continue block15;
                            }
                            case 2: {
                                this.writesIssued[currentDisk] = foo;
                                continue block15;
                            }
                            case 3: {
                                this.writeSectors[currentDisk] = foo;
                                continue block15;
                            }
                            default: {
                                throw new NoSuchResourceException("Resource " + j + " is not valid for disk or partition");
                            }
                        }
                    }
                    continue;
                }
                for (j = 0; j < 11; ++j) {
                    foo = 0;
                    while (i < currentline.length() && currentline.charAt(i) >= '0' && currentline.charAt(i) <= '9') {
                        foo = foo * 10 + currentline.charAt(i) - 48;
                        ++i;
                    }
                    ++i;
                    if (j >= 11) {
                        throw new NoSuchResourceException("Resource " + j + " is not valid for disk or partition");
                    }
                    if (j == 7) {
                        foo /= 100;
                    }
                    ((long[])this.allResources.get((int)j))[currentDisk] = foo;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProbeException(e);
        }
    }
}

