/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.macosx;

import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;

public class MemoryProbe
extends AbstractProbe {
    private static final int NB_OF_RESOURCES = 11;
    private static final int TOTAL_MEMORY_RES = 0;
    private static final int USED_MEMORY_RES = 1;
    private static final int FREE_MEMORY_RES = 2;
    private static final int SHARED_RES = 3;
    private static final int BUFFERS_RES = 4;
    private static final int CACHED_RES = 5;
    private static final int TOTAL_SWAP_RES = 6;
    private static final int USED_SWAP_RES = 7;
    private static final int FREE_SWAP_RES = 8;
    private static final int PAGES_IN_RES = 9;
    private static final int PAGES_OUT_RES = 10;
    private long[] resourceValues;

    public MemoryProbe() {
        super("memory probe");
        this.resourceIds = new int[11];
        this.resourceValues = new long[11];
        for (int i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        this.resourceNames = new String[]{"Total memory", "Used memory", "Free memory", "Shared", "Buffers", "Cached", "Total swap", "Used swap", "Free swap", "Pages in", "Pages out"};
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getMemoryUsage();
        long[] result = new long[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 11) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            result[i] = this.resourceValues[resourceIds[i]];
        }
        return result;
    }

    private void getMemoryUsage() throws ProbeException {
        this.resourceValues = this.getMemoryStats();
    }

    public native long[] getMemoryStats() throws ProbeException;

    static {
        System.loadLibrary("LeWYS");
    }
}

