/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.windows;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;

public class CpuProbe
extends AbstractProbe {
    private long[] cpuTime;
    private long[] cpuUser;
    private long[] cpuPrivileged;
    private long[] cpuDPC;
    private long[] cpuInterrupt;
    private int nbOfCpus = 0;
    private String[] names = this.getInstanceNames();

    public CpuProbe() throws NoResourceToProbeException {
        super("cpu probe");
        int i;
        this.nbOfCpus = this.names.length;
        this.cpuTime = new long[this.nbOfCpus];
        this.cpuUser = new long[this.nbOfCpus];
        this.cpuPrivileged = new long[this.nbOfCpus];
        this.cpuDPC = new long[this.nbOfCpus];
        this.cpuInterrupt = new long[this.nbOfCpus];
        this.resourceNames = new String[this.nbOfCpus * 5];
        for (i = 0; i < this.nbOfCpus; ++i) {
            this.resourceNames[i * 5] = this.names[i] + "_total_time";
            this.resourceNames[i * 5 + 1] = this.names[i] + "_user";
            this.resourceNames[i * 5 + 2] = this.names[i] + "_privileged";
            this.resourceNames[i * 5 + 3] = this.names[i] + "_dpc";
            this.resourceNames[i * 5 + 4] = this.names[i] + "_interrupts";
        }
        this.resourceIds = new int[this.resourceNames.length];
        for (i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getCpuUsage();
        long[] result = new long[resourceIds.length];
        block7: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= this.resourceNames.length) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int cpu = resourceIds[i] / 5;
            switch (resourceIds[i] % 5) {
                case 0: {
                    result[i] = this.cpuTime[cpu];
                    continue block7;
                }
                case 1: {
                    result[i] = this.cpuUser[cpu];
                    continue block7;
                }
                case 2: {
                    result[i] = this.cpuPrivileged[cpu];
                    continue block7;
                }
                case 3: {
                    result[i] = this.cpuDPC[cpu];
                    continue block7;
                }
                case 4: {
                    result[i] = this.cpuInterrupt[cpu];
                    continue block7;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    private void getCpuUsage() throws ProbeException {
        for (int i = 0; i < this.nbOfCpus; ++i) {
            long[] cpuValues = this.getCpuState(this.names[i]);
            if (cpuValues.length != 5) continue;
            this.cpuTime[i] = cpuValues[0];
            this.cpuUser[i] = cpuValues[1];
            this.cpuPrivileged[i] = cpuValues[2];
            this.cpuDPC[i] = cpuValues[3];
            this.cpuInterrupt[i] = cpuValues[4];
        }
    }

    public native int getNbOfCpus();

    public native String[] getInstanceNames();

    public native long[] getCpusState(int var1);

    public native long[] getCpuState(String var1);

    static {
        System.loadLibrary("LeWYS");
    }
}

