/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.windows;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class KernelProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESSOURCES = 9;
    private long[] resourceValues;

    public KernelProbe() throws NoResourceToProbeException {
        super("kernel probe");
        this.resourceIds = new int[9];
        this.resourceValues = new long[9];
        for (int i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        this.resourceNames = new String[]{"Pages in", "Pages out", "Swap in", "Swap out", "Interrupts", "Context switches", "Processes", "Threads", "Exceptions", "System calls"};
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getKernelUsage();
        long[] result = new long[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 9) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            result[i] = this.resourceValues[resourceIds[i]];
        }
        return result;
    }

    private void getKernelUsage() throws ProbeException {
        this.resourceValues = this.getKernelState();
    }

    public native long[] getKernelState();

    static {
        System.loadLibrary("LeWYS");
    }
}

