/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository.requestplayer;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.objectweb.cjdbc.common.util.Stats;
import org.objectweb.lewys.repository.requestplayer.ClientEmulator;
import org.objectweb.lewys.repository.requestplayer.RequestPlayerProperties;
import org.objectweb.lewys.repository.util.TimeManagement;

public class MonitoringThread
extends Thread {
    private Stats selectStats = null;
    private Stats unknownStats = null;
    private Stats updateStats = null;
    private Stats insertStats = null;
    private Stats deleteStats = null;
    private ClientEmulator father;
    private long timeInMs;
    private boolean killed = false;
    private Connection conn = null;

    public MonitoringThread(ClientEmulator father, long timeInMs) {
        super("MonitoringThread");
        this.selectStats = father.getSelectStats();
        this.unknownStats = father.getUnknownStats();
        this.updateStats = father.getUpdateStats();
        this.insertStats = father.getInsertStats();
        this.deleteStats = father.getDeleteStats();
        this.father = father;
        this.timeInMs = timeInMs;
        this.conn = father.getConnection();
    }

    public void run() {
        int oldStats = 0;
        Statement insertStmt = null;
        int i = 0;
        while (!this.killed) {
            try {
                Thread.sleep(this.timeInMs);
            }
            catch (InterruptedException e) {
                if (this.killed) break;
                System.out.println("Monitoring thread interrupted");
                break;
            }
            int currentStats = this.selectStats.getCount() + this.updateStats.getCount() + this.insertStats.getCount() + this.deleteStats.getCount() + this.unknownStats.getCount();
            int diff = currentStats - oldStats;
            oldStats = currentStats;
            RequestPlayerProperties requestPlayerProp = this.father.getRequestPlayerProp();
            String innoDB = requestPlayerProp.getDatabaseURL().toLowerCase().indexOf("innodb") != -1 ? "Y" : "N";
            String currentTime = TimeManagement.currentDateToString();
            try {
                insertStmt = this.conn.prepareStatement("INSERT INTO stats (param_name,param_desc,innoDB,batch_size,thread_count,table_count,monitor_interval,value,timestmp) values('insert_count','number of completed insert statements',?,?,?,?,?,?,'" + currentTime + "')");
                insertStmt.setString(1, innoDB);
                insertStmt.setInt(2, requestPlayerProp.getBatchSize());
                insertStmt.setInt(3, requestPlayerProp.getNbClients());
                insertStmt.setInt(4, requestPlayerProp.getNbTables());
                insertStmt.setLong(5, this.timeInMs);
                insertStmt.setLong(6, diff);
                insertStmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    if (insertStmt != null) {
                        insertStmt.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                System.err.println(": An error occured while executing SQL request (" + e.getMessage() + ")");
            }
            ++i;
        }
        try {
            if (insertStmt != null) {
                insertStmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    public boolean isKilled() {
        return this.killed;
    }

    public void setKilled(boolean killed) {
        this.killed = killed;
    }
}

