/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository.requestplayer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class RequestPlayerProperties
extends Properties {
    public static final String DEFAULT_CONFIG_FILE = "requestplayer.properties";
    public static final int STANDARD_CONNECTION = 0;
    public static final int FIXED_CONNECTION = 1;
    public static final int POOLING_CONNECTION = 2;
    public static final int SINGLE_UPDATE = 3;
    public static final int BULK_UPDATE = 4;
    private File configFile;
    private String traceFile;
    private int nbRequests = 0;
    private int nbClients = 0;
    private int nbTables = 0;
    private int timeout = 0;
    private String databaseDriver;
    private String databaseUrl;
    private String databaseLogin;
    private String databasePassword;
    private int updateType;
    private long timeInMS;
    private int batchSize;
    private boolean innoDB;
    private int connectionType;
    private int poolSize = 0;

    public RequestPlayerProperties(String configFileString) {
        if (configFileString == null) {
            this.configFile = new File(DEFAULT_CONFIG_FILE);
        } else {
            this.configFile = new File(configFileString);
            if (!this.configFile.isFile() || !this.configFile.exists()) {
                System.err.println("Cannot read the request player configuration file '" + this.configFile.toString() + "'");
                Runtime.getRuntime().exit(1);
            }
        }
        try {
            InputStream stream = null;
            if (configFileString == null) {
                stream = RequestPlayerProperties.class.getResourceAsStream("/requestplayer.properties");
                if (stream == null) {
                    System.err.println("Cannot find request player properties file 'requestplayer.properties' in classpath");
                }
            } else {
                stream = new FileInputStream(this.configFile);
            }
            super.load(stream);
            stream.close();
        }
        catch (IOException e) {
            System.err.println("An error occured when reading the request player properties file '" + this.configFile.toString() + "'");
            Runtime.getRuntime().exit(1);
        }
    }

    public boolean checkPropertiesFile() {
        try {
            System.out.println();
            System.out.println("### Database information ###");
            this.databaseUrl = this.getProperty("db_url");
            System.out.println("Database url       : " + this.databaseUrl);
            this.databaseDriver = this.getProperty("db_driver");
            System.out.println("Database driver    : " + this.databaseDriver);
            this.databaseLogin = this.getProperty("db_username");
            System.out.println("Username           : " + this.databaseLogin);
            this.databasePassword = this.getProperty("db_password");
            System.out.println("Password           : " + this.databasePassword);
            System.out.println();
            System.out.println("### General information ###");
            this.traceFile = this.getProperty("trace_file");
            System.out.println("Trace file          : " + this.traceFile);
            this.nbRequests = new Integer(this.getProperty("nb_requests"));
            System.out.println("Number of requests  : " + this.nbRequests);
            this.timeout = new Integer(this.getProperty("timeout"));
            System.out.println("Timeout on requests : " + this.timeout + " seconds");
            this.nbClients = new Integer(this.getProperty("nb_clients"));
            System.out.println("Number of clients   : " + this.nbClients);
            this.nbTables = new Integer(this.getProperty("nb_tables"));
            System.out.println("Number of tables   : " + this.nbTables);
            String connType = this.getProperty("connection_type");
            System.out.println("Connection type     : " + connType);
            if (connType.equalsIgnoreCase("fixed")) {
                this.connectionType = 1;
            } else if (connType.equalsIgnoreCase("standard")) {
                this.connectionType = 0;
            } else if (connType.equalsIgnoreCase("pooling")) {
                this.connectionType = 2;
                this.poolSize = new Integer(this.getProperty("poolsize"));
                System.out.println("Connection pool size: " + this.poolSize);
            }
            String uType = this.getProperty("updateType");
            System.out.println("Update Type   : " + uType);
            if (uType.equalsIgnoreCase("single")) {
                this.updateType = 3;
            } else if (uType.equalsIgnoreCase("bulk")) {
                this.updateType = 4;
            }
            this.timeInMS = new Integer(this.getProperty("timeInMS")).intValue();
            System.out.println("Time to recheck in milliseconds: " + this.timeInMS);
            this.batchSize = new Integer(this.getProperty("batchSize"));
            System.out.println("Batch Size   : " + this.batchSize);
            return true;
        }
        catch (Exception e) {
            System.err.println("Error while checking request player properties file '" + this.configFile.toString() + "': " + e.getMessage());
            return false;
        }
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public int getNbRequests() {
        return this.nbRequests;
    }

    public String getDatabaseURL() {
        return this.databaseUrl;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseUsername() {
        return this.databaseLogin;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public int getNbClients() {
        return this.nbClients;
    }

    public int getNbTables() {
        return this.nbTables;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getUpdateType() {
        return this.updateType;
    }

    public long getTimeInMS() {
        return this.timeInMS;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

