/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository.util;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.objectweb.lewys.common.exceptions.RepositoryException;
import org.objectweb.lewys.filtering.SignalPoint;
import org.objectweb.lewys.repository.MonitoringRepositoryImpl;

public class SignalComparator {
    private MonitoringRepositoryImpl repository = new MonitoringRepositoryImpl();
    private Connection conn = this.repository.getConnection();

    public void compareSignals() throws RepositoryException {
        ArrayList<Integer> probe_resources = new ArrayList<Integer>();
        ArrayList<Double> precision_widths = new ArrayList<Double>();
        ArrayList<Long> sampling_freqs = new ArrayList<Long>();
        ArrayList<Integer> filter_types = new ArrayList<Integer>();
        String[] measureNames = new String[]{"percentage of updates", "average error"};
        double[] measureValues = new double[2];
        String[] fields = new String[]{"cache", "linear", "swing", "slide1", "slide2", "hybrid", "cache_linear"};
        ResultSet rs = null;
        PreparedStatement selectStmt = null;
        Statement insertStmt = null;
        Statement updateStmt = null;
        try {
            selectStmt = this.conn.prepareStatement("SELECT probe_resource,precision_width,sampling_freq,filter_type FROM measurements1 WHERE filter_type<>0 GROUP BY probe_resource,precision_width,sampling_freq,filter_type");
            rs = selectStmt.executeQuery();
            while (rs.next()) {
                probe_resources.add(new Integer(rs.getInt("probe_resource")));
                precision_widths.add(new Double(rs.getDouble("precision_width")));
                sampling_freqs.add(new Long(rs.getLong("sampling_freq")));
                filter_types.add(new Integer(rs.getInt("filter_type")));
            }
            selectStmt.close();
            selectStmt = null;
            for (int i = 0; i < probe_resources.size(); ++i) {
                int probe_resource = (Integer)probe_resources.get(i);
                double precision_width = (Double)precision_widths.get(i);
                long sampling_freq = (Long)sampling_freqs.get(i);
                int filter_type = (Integer)filter_types.get(i);
                measureValues[0] = this.calculateUpdatePercentage(probe_resource, precision_width, sampling_freq, filter_type);
                measureValues[1] = this.calculateError(probe_resource, precision_width, sampling_freq, filter_type);
                for (int j = 0; j < measureNames.length; ++j) {
                    updateStmt = this.conn.prepareStatement("UPDATE comparison SET " + fields[filter_type - 1] + "=? " + "WHERE probe_resource=? AND precision_width=? AND sampling_freq=? AND measure=?");
                    updateStmt.setDouble(1, measureValues[j]);
                    updateStmt.setInt(2, probe_resource);
                    updateStmt.setDouble(3, precision_width);
                    updateStmt.setLong(4, sampling_freq);
                    updateStmt.setString(5, measureNames[j]);
                    int rowCount = updateStmt.executeUpdate();
                    updateStmt.close();
                    updateStmt = null;
                    if (rowCount != 0) continue;
                    insertStmt = this.conn.prepareStatement("INSERT INTO comparison (probe_resource,precision_width,sampling_freq,measure,cache,linear,swing,slide1,slide2,hybrid) values(?,?,?,?, ?,?,?,?,?,?)");
                    insertStmt.setInt(1, probe_resource);
                    insertStmt.setDouble(2, precision_width);
                    insertStmt.setLong(3, sampling_freq);
                    insertStmt.setString(4, measureNames[j]);
                    for (int k = 5; k <= 10; ++k) {
                        insertStmt.setDouble(k, 0.0);
                    }
                    insertStmt.setDouble(4 + filter_type, measureValues[j]);
                    insertStmt.executeUpdate();
                    insertStmt.close();
                    insertStmt = null;
                }
            }
            this.repository.shutDown();
        }
        catch (SQLException e) {
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (insertStmt != null) {
                    insertStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new RepositoryException("Error while accessing database: " + e);
        }
    }

    public double calculateUpdatePercentage(int probe_resource, double precision_width, long sampling_freq, int filter_type) throws RepositoryException {
        int count2;
        int count1;
        ResultSet rs = null;
        PreparedStatement selectStmt = null;
        try {
            selectStmt = this.conn.prepareStatement("SELECT count(*) as count FROM measurements1 WHERE probe_resource=? AND precision_width=? AND sampling_freq=? AND filter_type=? ");
            selectStmt.setInt(1, probe_resource);
            selectStmt.setDouble(2, precision_width);
            selectStmt.setLong(3, sampling_freq);
            selectStmt.setInt(4, filter_type);
            rs = selectStmt.executeQuery();
            rs.next();
            count1 = rs.getInt("count");
            selectStmt.close();
            selectStmt = null;
            selectStmt = this.conn.prepareStatement("SELECT count(*) as count FROM measurements1 WHERE probe_resource=? AND filter_type=0 ");
            selectStmt.setInt(1, probe_resource);
            rs = selectStmt.executeQuery();
            rs.next();
            count2 = rs.getInt("count");
            selectStmt.close();
            selectStmt = null;
        }
        catch (SQLException e) {
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new RepositoryException("Error while accessing database: " + e);
        }
        double percentage = (double)count1 / (double)count2;
        return percentage;
    }

    public double calculateError(int probe_resource, double precision_width, long sampling_freq, int filter_type) throws RepositoryException {
        ArrayList<SignalPoint> usedPoints = new ArrayList<SignalPoint>();
        ArrayList<SignalPoint> allPoints = new ArrayList<SignalPoint>();
        ResultSet rs = null;
        PreparedStatement selectStmt = null;
        try {
            SignalPoint point;
            double value;
            double timestamp;
            selectStmt = this.conn.prepareStatement("SELECT timestmp,value FROM measurements1 WHERE probe_resource=? AND precision_width=? AND sampling_freq=? AND filter_type=? ORDER BY timestmp asc");
            selectStmt.setInt(1, probe_resource);
            selectStmt.setDouble(2, precision_width);
            selectStmt.setLong(3, sampling_freq);
            selectStmt.setInt(4, filter_type);
            rs = selectStmt.executeQuery();
            while (rs.next()) {
                timestamp = rs.getLong("timestmp");
                value = rs.getDouble("value");
                point = new SignalPoint(timestamp, value);
                usedPoints.add(point);
            }
            selectStmt.close();
            selectStmt = null;
            selectStmt = this.conn.prepareStatement("SELECT timestmp,value FROM measurements1 WHERE probe_resource=? AND filter_type=0 ORDER BY timestmp asc");
            selectStmt.setInt(1, probe_resource);
            rs = selectStmt.executeQuery();
            while (rs.next()) {
                timestamp = rs.getLong("timestmp");
                value = rs.getDouble("value");
                point = new SignalPoint(timestamp, value);
                allPoints.add(point);
            }
            double sumError = 0.0;
            int j = 0;
            SignalPoint point2 = (SignalPoint)allPoints.get(j++);
            for (int i = 0; i < usedPoints.size() - 1; ++i) {
                SignalPoint usedPrev = (SignalPoint)usedPoints.get(i);
                SignalPoint usedNext = (SignalPoint)usedPoints.get(i + 1);
                double deltaValue = usedNext.getValue() - usedPrev.getValue();
                double deltaTime = usedNext.getTime() - usedPrev.getTime();
                if (point2.getTime() == usedPrev.getTime()) {
                    point2 = (SignalPoint)allPoints.get(j++);
                }
                while (point2.getTime() > usedPrev.getTime() && point2.getTime() < usedNext.getTime() && j < allPoints.size()) {
                    double approxValue = filter_type == 1 ? usedPrev.getValue() : usedPrev.getValue() + deltaValue / deltaTime * (point2.getTime() - usedPrev.getTime());
                    double sumErrorOld = sumError;
                    sumError += Math.abs(point2.getValue() - approxValue);
                    point2 = (SignalPoint)allPoints.get(j++);
                }
            }
            int n = j + 1;
            double avgError = sumError / (double)n;
            return avgError;
        }
        catch (SQLException e) {
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new RepositoryException("Error while accessing database: " + e);
        }
    }

    public static void main(String[] args) {
        try {
            SignalComparator comparator = new SignalComparator();
            comparator.compareSignals();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

