/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Grapher;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.Configurator;
import org.ow2.jasmine.monitoring.mbeancmd.jasmine.JasmineConnector;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XServerSampler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Poll
extends AbstractCommand {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected XServerSampler xss = null;
    private Options options = null;
    private CommandLine commandLine = null;
    private long period = 10L;
    private boolean isHttpOption = false;
    private boolean isServerOption = false;
    private boolean isTxOption = false;
    private boolean isCpuSunOption = false;
    private boolean isDataSourceOption = false;
    private boolean isJCACFSourceOption = false;
    private boolean isJoramQueueOption = false;
    private boolean isServletOption = false;
    private boolean isStatelessOption = false;
    private boolean isStatefulOption = false;
    private boolean isEntityOption = false;
    private boolean isConsoleOption = false;
    private String graphDef = null;
    private String outputFilePath = null;
    private String jasmineURI = null;
    private boolean isDtdOption = false;
    private String onPattern = null;
    private String separator = ";";
    private String cmdid = null;

    public Poll() {
        this.setOptions();
    }

    public void stop() {
        if (this.xss != null) {
            this.xss.stopProcessing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(CommandDispatcher cmdDispatcher) {
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            cmdDispatcher.setFailed(e.getMessage());
            e.printStackTrace();
            return 1;
        }
        if (this.isDtdOption) {
            this.printDtd();
            return 0;
        }
        if (this.isHttpOption) {
            this.xss = new XServerSampler("web");
        } else if (this.isTxOption) {
            this.xss = new XServerSampler("tx");
        } else if (this.isCpuSunOption) {
            this.xss = new XServerSampler("cpusun");
        } else if (this.isServerOption) {
            this.xss = new XServerSampler("server");
        } else if (this.isJCACFSourceOption) {
            this.xss = new XServerSampler("jcacf");
            this.xss.setOnPattern(this.onPattern);
        } else if (this.isJoramQueueOption) {
            this.xss = new XServerSampler("joramQueue");
            this.xss.setOnPattern(this.onPattern);
        } else if (this.isDataSourceOption) {
            this.xss = new XServerSampler("datasource");
            this.xss.setOnPattern(this.onPattern);
        } else if (this.isServletOption) {
            this.xss = new XServerSampler("servlet");
            this.xss.setOnPattern(this.onPattern);
        } else if (this.isStatelessOption) {
            this.xss = new XServerSampler("stateless");
            this.xss.setOnPattern(this.onPattern);
        } else if (this.isStatefulOption) {
            this.xss = new XServerSampler("stateful");
            this.xss.setOnPattern(this.onPattern);
        } else if (this.isEntityOption) {
            this.xss = new XServerSampler("entity");
            this.xss.setOnPattern(this.onPattern);
        }
        if (this.xss == null) {
            System.err.println("Option missing!");
            cmdDispatcher.setFailed("Missing option");
            return 2;
        }
        this.xss.setCmdId(this.cmdid);
        String[] requestedTargets = this.commandLine.getOptionValues("target");
        if (requestedTargets == null && JmxHelper.getDefaultJmxTarget() == null) {
            String message = "Target not found";
            this.logger.error(message, new Object[0]);
            cmdDispatcher.setFailed(message);
            return 2;
        }
        String[] managee = JmxHelper.getJmxTargets(requestedTargets);
        if (managee != null && managee.length > 0) {
            int nbTargets = 1;
            String targets = managee[0];
            for (int i = 0; i < managee.length; ++i) {
                this.xss.addManagee(managee[i], JmxHelper.getJmxUrl(managee[i]));
                if (i <= 0) continue;
                targets = targets + ", " + managee[i];
                ++nbTargets;
            }
            if (nbTargets > 1) {
                this.logger.info("The polled targets are {0}: ", targets);
            } else {
                this.logger.info("The polled target is {0}: ", targets);
            }
        } else {
            String message;
            if (requestedTargets.length == 1) {
                message = "The requested target " + requestedTargets[0] + "is not defined.";
            } else {
                String targets = requestedTargets[0];
                for (int i = 1; i < requestedTargets.length; ++i) {
                    targets = targets + ", " + requestedTargets[i];
                }
                message = "The requested targets " + targets + "are not defined.";
            }
            this.logger.error(message, new Object[0]);
            cmdDispatcher.setFailed(message);
            return 2;
        }
        PipedOutputStream out = new PipedOutputStream();
        PrintStream pout = new PrintStream(out);
        Outer outer = null;
        try {
            if (this.isConsoleOption) {
                outer = new Outer(out, System.out);
            }
            if (this.outputFilePath != null) {
                if (outer == null) {
                    outer = new Outer(out, new File(this.outputFilePath));
                } else {
                    Outer consoleOuter = outer;
                    PipedOutputStream sink = new PipedOutputStream();
                    consoleOuter.setSink(sink);
                    outer = new Outer(sink, new File(this.outputFilePath));
                    new Thread(consoleOuter).start();
                }
            } else if (this.jasmineURI == null && outer == null) {
                outer = new Outer(out, System.out);
            }
            if (this.jasmineURI != null) {
                if (outer == null) {
                    outer = JasmineConnector.connect(out, this.jasmineURI);
                } else {
                    Outer oldOuter = outer;
                    outer = JasmineConnector.connect(outer, this.jasmineURI);
                    new Thread(oldOuter).start();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.graphDef != null) {
            try {
                PipedOutputStream sink = new PipedOutputStream();
                outer.setSink(sink);
                Grapher gr = new Grapher(sink, this.graphDef);
                gr.start();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        new Thread(outer).start();
        this.xss.setCommandDispatcher(cmdDispatcher);
        try {
            this.xss.process(this.period, pout);
            cmdDispatcher.setStopped();
        }
        catch (Exception e) {
            this.logger.error("Poll error:" + e, new Object[0]);
        }
        finally {
            pout.close();
        }
        return 0;
    }

    public void help() {
        super.help();
        System.out.println("DTD for graph definitions:\n");
        this.printDtd();
    }

    private void printDtd() {
        LineNumberReader ln = Configurator.getDTD();
        if (ln != null) {
            try {
                String line = null;
                while ((line = ln.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public String summary() {
        return "Probes one or more J2EE servers and prints statistics";
    }

    public static void main(String[] args) {
        Poll p = new Poll();
        p.setArgs("poll", args);
        p.exec(null);
    }

    public void parseCommandLine(String[] args) throws ParseException {
        String s;
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.isHttpOption = this.commandLine.hasOption("http");
        this.isTxOption = this.commandLine.hasOption("tx");
        this.isCpuSunOption = this.commandLine.hasOption("cpusun");
        this.isServerOption = this.commandLine.hasOption("server");
        this.isConsoleOption = this.commandLine.hasOption("console");
        this.isDtdOption = this.commandLine.hasOption("dtd");
        this.isDataSourceOption = this.commandLine.hasOption("ds");
        if (this.isDataSourceOption) {
            this.onPattern = this.commandLine.getOptionValue("ds");
        }
        this.isJCACFSourceOption = this.commandLine.hasOption("jcacf");
        if (this.isJCACFSourceOption) {
            this.onPattern = this.commandLine.getOptionValue("jcacf");
        }
        this.isJoramQueueOption = this.commandLine.hasOption("joramq");
        if (this.isJoramQueueOption) {
            this.onPattern = this.commandLine.getOptionValue("joramq");
        }
        this.isServletOption = this.commandLine.hasOption("servlet");
        if (this.isServletOption) {
            this.onPattern = this.commandLine.getOptionValue("servlet");
        }
        this.isStatelessOption = this.commandLine.hasOption("slb");
        if (this.isStatelessOption) {
            this.onPattern = this.commandLine.getOptionValue("slb");
        }
        this.isStatefulOption = this.commandLine.hasOption("sfb");
        if (this.isStatefulOption) {
            this.onPattern = this.commandLine.getOptionValue("sfb");
        }
        this.isEntityOption = this.commandLine.hasOption("ent");
        if (this.isEntityOption) {
            this.onPattern = this.commandLine.getOptionValue("ent");
        }
        if ((s = this.commandLine.getOptionValue("p")) != null) {
            this.period = Long.parseLong(s);
        }
        if (this.commandLine.hasOption("graph")) {
            this.graphDef = this.commandLine.getOptionValue("graph");
        }
        if (this.commandLine.hasOption("cmdid")) {
            this.cmdid = this.commandLine.getOptionValue("cmdid");
        }
        if (this.commandLine.hasOption("f")) {
            this.outputFilePath = this.commandLine.getOptionValue("f");
        }
        if (this.commandLine.hasOption("jasmine")) {
            this.jasmineURI = this.commandLine.getOptionValue("jasmine");
        }
        if (this.commandLine.hasOption("s")) {
            this.separator = this.commandLine.getOptionValue("s");
            Outer.setSeparator(this.separator);
            SampleData.setSeparator(this.separator);
        }
    }

    private void setOptions() {
        this.options = new Options();
        Option period = new Option("p", "period", true, "Polling period");
        period.setRequired(false);
        period.setArgName("seconds");
        period.setArgs(1);
        this.options.addOption(period);
        OptionGroup polls = new OptionGroup();
        polls.setRequired(false);
        Option http = new Option("http", "http", false, "HTTP Statistics");
        polls.addOption(http);
        Option tx = new Option("tx", "tx", false, "Transaction Statistics");
        polls.addOption(tx);
        Option cpuSun = new Option("cpusun", "cpusun", false, "Sun CPU Statistics");
        polls.addOption(cpuSun);
        Option svr = new Option("server", "server", false, "Server Statistics");
        polls.addOption(svr);
        Option ds = new Option("ds", "ds", false, "DataSource Statistics");
        ds.setArgs(1);
        ds.setArgName("mbean pattern");
        polls.addOption(ds);
        Option jcacf = new Option("jcacf", "jcacf", false, "JCA Connection Factory Statistics");
        jcacf.setArgs(1);
        jcacf.setArgName("mbean pattern");
        polls.addOption(jcacf);
        Option joramq = new Option("joramq", "joramq", false, "Joram Queues Statistics");
        joramq.setArgs(1);
        joramq.setArgName("mbean pattern");
        polls.addOption(joramq);
        Option servlet = new Option("servlet", "servlet", true, "Servlet Statistics");
        servlet.setArgs(1);
        servlet.setArgName("mbean pattern");
        polls.addOption(servlet);
        Option stateless = new Option("slb", "stateless", true, "Stateless Session bean Statistics");
        stateless.setArgs(1);
        stateless.setArgName("mbean pattern");
        polls.addOption(stateless);
        Option stateful = new Option("sfb", "stateful", true, "Stateful Session bean Statistics");
        stateful.setArgs(1);
        stateful.setArgName("mbean pattern");
        polls.addOption(stateful);
        Option entity = new Option("ent", "entity", true, "Stateful Session bean Statistics");
        entity.setArgs(1);
        entity.setArgName("mbean pattern");
        polls.addOption(entity);
        Option mbean = new Option("mbean", "mbean", true, "Any MBean Statistics");
        mbean.setArgs(128);
        mbean.setArgName("mbean pattern and attributes");
        polls.addOption(mbean);
        Option dtd = new Option("dtd", "dtd", false, "DTD for graph definitions");
        polls.addOption(dtd);
        Option separator = new Option("s", "separator", true, "Set the column separator");
        separator.setRequired(false);
        separator.setArgName("separator");
        separator.setArgs(1);
        this.options.addOption(separator);
        Option cmdid = new Option("cmdid", "cmdid", true, "Cmd Identifier");
        cmdid.setRequired(false);
        cmdid.setArgName("cmdid");
        cmdid.setArgs(1);
        this.options.addOption(cmdid);
        this.options.addOptionGroup(polls);
        Option graph = new Option("graph", "graph", true, "Enable graphical output");
        graph.setRequired(false);
        graph.setArgName("graphDefinition");
        graph.setArgs(1);
        this.options.addOption(graph);
        Option file = new Option("f", "file", true, "Send output to file");
        file.setRequired(false);
        file.setArgName("path");
        file.setArgs(1);
        this.options.addOption(file);
        Option console = new Option("console", "console", false, "Send output to stdout");
        console.setRequired(false);
        this.options.addOption(console);
        Option jasmine = new Option("jasmine", "jasmine", true, "Output logged data to jasmine (will disable stdout)");
        jasmine.setRequired(false);
        jasmine.setArgName("jasmineURI");
        jasmine.setArgs(1);
        this.options.addOption(jasmine);
        Option target = new Option("target", "target", true, "Server instances to poll");
        target.setRequired(false);
        target.setOptionalArg(true);
        target.setArgs(-2);
        target.setArgName("instances");
        this.options.addOption(target);
    }
}

