/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.converters;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public class QNameConverter
implements Converter {
    protected final boolean explicit;

    public QNameConverter() {
        this(false);
    }

    public QNameConverter(boolean explicit) {
        this.explicit = explicit;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            throw new ConversionException("No value specified");
        }
        if (value instanceof QName) {
            return value;
        }
        String val = value.toString();
        if (val.startsWith("qname{")) {
            return this.parseQName(val.substring(6, val.length() - 1));
        }
        if (!this.explicit) {
            return this.parseQName(val);
        }
        return new QName(val);
    }

    protected QName parseQName(String val) {
        StringTokenizer st = new StringTokenizer(val, ":");
        ArrayList<String> elements = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            elements.add(st.nextToken());
        }
        switch (elements.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new QName((String)elements.get(0));
            }
            case 2: {
                return new QName((String)elements.get(0), (String)elements.get(1));
            }
            case 3: {
                return new QName((String)elements.get(1) + ":" + (String)elements.get(2), (String)elements.get(0));
            }
        }
        String prefix = (String)elements.get(0);
        String local = (String)elements.get(1);
        String ns = val.substring(prefix.length() + local.length() + 2);
        return new QName(ns, local, prefix);
    }
}

