/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.adl;

import java.util.HashMap;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.util.Fractal;

public final class Launcher {
    private Launcher() {
    }

    public static void main(String[] args) throws Exception {
        String[] pargs = Launcher.parseArgs(args);
        Object comp = Launcher.createComponent(pargs);
        if (comp instanceof Component) {
            LifeCycleController lc = null;
            try {
                lc = Fractal.getLifeCycleController((Component)comp);
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
            if (lc != null) {
                lc.startFc();
            }
            Runnable r = null;
            try {
                r = (Runnable)((Component)comp).getFcInterface(pargs[2]);
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
            if (r != null) {
                r.run();
            }
        } else {
            if (comp instanceof LifeCycleController) {
                ((LifeCycleController)comp).startFc();
            }
            if (comp instanceof Runnable) {
                ((Runnable)comp).run();
            }
        }
    }

    private static Object createComponent(String[] pargs) throws Exception {
        Factory f = FactoryFactory.getFactory(pargs[0], pargs[1], new HashMap());
        return f.newComponent(pargs[2], new HashMap());
    }

    private static String[] parseArgs(String[] args) {
        if (args.length < 1 || args.length > 4) {
            Launcher.parseError();
        }
        String[] result = new String[4];
        int i = 0;
        if (args[i].startsWith("-factory=")) {
            result[0] = args[i].substring(9);
            ++i;
        } else {
            result[0] = "org.objectweb.dream.adl.BasicFactory";
        }
        if (args.length == i) {
            Launcher.parseError();
        }
        if (args[i].startsWith("-backend=")) {
            result[1] = args[i].substring(9);
            ++i;
        } else {
            result[1] = "org.objectweb.fractal.adl.FractalBackend";
        }
        if (args.length == i) {
            Launcher.parseError();
        }
        result[2] = args[i];
        result[3] = args.length == ++i ? "run" : args[i];
        if (args.length > i + 1) {
            Launcher.parseError();
        }
        return result;
    }

    private static void parseError() {
        System.out.print("Usage: Launcher [-factory=<factory def>|-backend=");
        System.out.println("<backend def>] <definition> [ <itf> ]");
        System.out.print("where <definition> is the name of the component to be ");
        System.out.print("instantiated and started,\n      <itf> is the name of ");
        System.out.print("its Runnable interface, if it has one,\n      ");
        System.out.print("<factory def> is the name of the factory implementation");
        System.out.print(" to be used (if not specified use Dream implementation)");
        System.out.print(",\n      <backend def> is the name of the backend ");
        System.out.print("implementation to be used (if not specified use Fractal");
        System.out.print(" implementation for Dream factory)");
        System.exit(1);
    }
}

