/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.channel.SocketManager;
import org.objectweb.dream.channel.SocketState;
import org.objectweb.dream.channel.WaitByte;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.codec.MessageCodec;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public class GenericPushChannelOutImpl
extends AbstractComponent
implements Push {
    public static final String WAIT_ACK_OPT_ITF_NAME = "wait-ack-opt";
    protected MessageManager messageManagerItf;
    protected MessageCodec messageCodecItf;
    protected SocketManager socketManagerItf;
    protected WaitByte waitAckOptItf;

    public void push(Message message, Map context) throws PushException {
        try {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("try to send message -> " + message));
            }
            SocketState socketState = this.socketManagerItf.getSocket(message);
            this.logger.log(BasicLevel.DEBUG, (Object)"write message");
            this.messageCodecItf.encode(socketState.getOutput(), message);
            if (this.waitAckOptItf != null) {
                this.waitAckOptItf.waitByte(socketState.getInput());
            }
            this.socketManagerItf.releaseSocket(socketState);
        }
        catch (IOException e) {
            throw new PushException(e);
        }
        this.messageManagerItf.deleteMessage(message);
    }

    public String[] listFc() {
        return new String[]{"message-manager", "message-codec", "socket-manager", WAIT_ACK_OPT_ITF_NAME};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        } else if (clientItfName.equals("message-codec")) {
            this.messageCodecItf = (MessageCodec)serverItf;
        } else if (clientItfName.equals("socket-manager")) {
            this.socketManagerItf = (SocketManager)serverItf;
        } else if (clientItfName.equals(WAIT_ACK_OPT_ITF_NAME)) {
            this.waitAckOptItf = (WaitByte)serverItf;
        }
    }

    public void unbindFc(String clientItfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.unbindFc(clientItfName);
        if (clientItfName.equals(WAIT_ACK_OPT_ITF_NAME)) {
            this.waitAckOptItf = null;
        }
    }
}

