/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.objectweb.dream.InitializationException;
import org.objectweb.dream.PushException;
import org.objectweb.dream.channel.AbstractTCPChannelInImpl;
import org.objectweb.dream.channel.MultiConnTCPChannelInAttributeController;
import org.objectweb.dream.control.activity.Util;
import org.objectweb.dream.control.activity.task.AbstractTask;
import org.objectweb.dream.control.activity.task.Task;
import org.objectweb.dream.control.activity.task.TaskController;
import org.objectweb.dream.control.activity.task.thread.ThreadPoolAttributeController;
import org.objectweb.dream.control.activity.task.thread.ThreadPoolController;
import org.objectweb.dream.control.activity.task.thread.ThreadPoolOverflowException;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.util.Error;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.julia.control.lifecycle.ChainedIllegalLifeCycleException;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.api.BasicLevel;

public class MultiConnTCPChannelInImpl
extends AbstractTCPChannelInImpl
implements MultiConnTCPChannelInAttributeController {
    protected ServerSocket listen;
    protected Task connectionTask = new ConnectionTask();
    protected Task inTask = new InTask();
    protected ThreadPoolController threadPoolController;
    protected ThreadPoolAttributeController threadPoolAttributeController;
    protected LinkedList availableSocketList = new LinkedList();
    protected int maxConnection;
    protected int nbConnection = 0;
    protected int soTimeout = -1;

    protected void initComponent(Component componentItf) throws InitializationException {
        super.initComponent(componentItf);
        try {
            Util.addTask(componentItf, this.connectionTask, Collections.EMPTY_MAP);
            HashMap<String, String> hints = new HashMap<String, String>();
            hints.put("thread", "pool");
            this.logger.log(BasicLevel.DEBUG, (Object)("Initial Max connection=" + this.maxConnection));
            Util.addTask(componentItf, this.inTask, hints);
        }
        catch (Exception e) {
            throw new InitializationException(e, componentItf, "Can't add task");
        }
    }

    protected void setSocketOption(Socket sock) throws SocketException {
        if (this.soTimeout >= 0) {
            sock.setSoTimeout(this.soTimeout);
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        super.startFc();
        try {
            TaskController tc = (TaskController)this.weaveableC.getFcInterface("task-controller");
            this.threadPoolController = (ThreadPoolController)tc.getTaskControl(this.inTask);
            this.threadPoolAttributeController = (ThreadPoolAttributeController)Fractal.getAttributeController(((Interface)((Object)this.threadPoolController)).getFcItfOwner());
            this.threadPoolAttributeController.setCapacity(this.getMaxConnection());
        }
        catch (Exception e) {
            throw new ChainedIllegalLifeCycleException(e, null, "An error occurs while retreiving task control interface");
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        super.stopFc();
        this.threadPoolController = null;
        this.threadPoolAttributeController = null;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
        if (this.threadPoolAttributeController != null) {
            this.threadPoolAttributeController.setCapacity(maxConnection);
        }
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    protected class ConnectionState {
        protected Socket socket;
        protected ObjectInputStream input;
        protected ObjectOutputStream output;

        protected ConnectionState(Socket socket) {
            this.socket = socket;
        }

        protected boolean isClosed() {
            return this.socket.isClosed() || !this.socket.isConnected();
        }

        protected ObjectInput getInput() throws IOException {
            if (this.input == null) {
                this.input = new ObjectInputStream(this.socket.getInputStream());
            }
            return this.input;
        }

        protected ObjectOutput getOutput() throws IOException {
            if (this.output == null) {
                this.output = new ObjectOutputStream(this.socket.getOutputStream());
            }
            return this.output;
        }

        protected void close() {
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (!this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected class InTask
    extends AbstractTask {
        public InTask() {
            super("ChannelIn-reader-task");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(Object hints) throws InterruptedException {
            ConnectionState connectionState;
            LinkedList linkedList = MultiConnTCPChannelInImpl.this.availableSocketList;
            synchronized (linkedList) {
                connectionState = (ConnectionState)MultiConnTCPChannelInImpl.this.availableSocketList.removeFirst();
            }
            MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"ChannelIn-reader-task : got a connection");
            if (connectionState.isClosed()) {
                this.stopThread(connectionState);
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"ChannelIn-reader-task : connection closed, stop thread");
                return STOP_EXECUTING;
            }
            try {
                ObjectInput input = connectionState.getInput();
                Message msg = MultiConnTCPChannelInImpl.this.messageCodecItf.decode(input);
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"ChannelIn-reader-task : message received");
                MultiConnTCPChannelInImpl.this.outPushItf.push(msg, null);
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"ChannelIn-reader-task : message pushed, send ack");
                MultiConnTCPChannelInImpl.this.sendAck(connectionState.socket);
            }
            catch (IOException e) {
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)"ChannelIn-reader-task : I/O error while receiving message, close connection", (Throwable)e);
                this.stopThread(connectionState);
                return STOP_EXECUTING;
            }
            catch (PushException e) {
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)e);
            }
            linkedList = MultiConnTCPChannelInImpl.this.availableSocketList;
            synchronized (linkedList) {
                MultiConnTCPChannelInImpl.this.availableSocketList.add(connectionState);
            }
            return EXECUTE_AGAIN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopThread(ConnectionState connectionState) {
            LinkedList linkedList = MultiConnTCPChannelInImpl.this.availableSocketList;
            synchronized (linkedList) {
                --MultiConnTCPChannelInImpl.this.nbConnection;
                MultiConnTCPChannelInImpl.this.availableSocketList.notify();
            }
            connectionState.close();
        }
    }

    protected class ConnectionTask
    extends AbstractTask {
        public ConnectionTask() {
            super("ChannelIn-connection-task");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(Object hints) throws InterruptedException {
            Socket socket;
            if (MultiConnTCPChannelInImpl.this.listen == null || MultiConnTCPChannelInImpl.this.listen.isClosed()) {
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"ChannelIn-connection-task : ServerSocket closed, create new one");
                try {
                    MultiConnTCPChannelInImpl.this.listen = MultiConnTCPChannelInImpl.this.createServerSocket(MultiConnTCPChannelInImpl.this.portNum);
                }
                catch (IOException e) {
                    MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.ERROR, (Object)"ChannelIn-connection-task : unable to open server socket", (Throwable)e);
                    return STOP_EXECUTING;
                }
            }
            try {
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"ChannelIn-connection-task : waiting connection");
                socket = MultiConnTCPChannelInImpl.this.listen.accept();
            }
            catch (SocketException e) {
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)e);
                return EXECUTE_AGAIN;
            }
            catch (IOException e) {
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)e);
                return EXECUTE_AGAIN;
            }
            try {
                MultiConnTCPChannelInImpl.this.setSocketOption(socket);
            }
            catch (SocketException e) {
                MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)e);
                try {
                    socket.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                return EXECUTE_AGAIN;
            }
            MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"ChannelIn-connection-task : connected");
            LinkedList linkedList = MultiConnTCPChannelInImpl.this.availableSocketList;
            synchronized (linkedList) {
                ++MultiConnTCPChannelInImpl.this.nbConnection;
                MultiConnTCPChannelInImpl.this.availableSocketList.add(new ConnectionState(socket));
                try {
                    MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"ChannelIn-connection-task : add a thread in thread pool");
                    MultiConnTCPChannelInImpl.this.threadPoolController.addThreads(1);
                }
                catch (ThreadPoolOverflowException e) {
                    MultiConnTCPChannelInImpl.this.logger.log(BasicLevel.ERROR, (Object)"ChannelIn-connection-task : Unable to add reader thread", (Throwable)e);
                    return STOP_EXECUTING;
                }
                catch (IllegalLifeCycleException e) {
                    Error.bug(MultiConnTCPChannelInImpl.this.logger, e);
                }
                while (MultiConnTCPChannelInImpl.this.nbConnection >= MultiConnTCPChannelInImpl.this.maxConnection) {
                    MultiConnTCPChannelInImpl.this.availableSocketList.wait();
                }
            }
            return EXECUTE_AGAIN;
        }
    }
}

