/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.control.lifecycle;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.control.lifecycle.LifeCycleCoordinator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class ThreadCounterMixin
implements LifeCycleCoordinator {
    protected Thread[] fcExecutingThreads;
    protected int[] fcInvocationCounters;
    protected int fcNbExcutingThread;
    protected LifeCycleCoordinator fcCoordinator;
    public Component _this_weaveableC;
    public int _this_weaveableFcState;
    public Logger _this_weaveableLCCLogger;

    public void initFcController(InitializationContext ic) throws InstantiationException {
        this.fcExecutingThreads = new Thread[2];
        this.fcInvocationCounters = new int[2];
        this.fcNbExcutingThread = 0;
        this._super_initFcController(ic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFcStarted() throws IllegalLifeCycleException {
        ThreadCounterMixin threadCounterMixin = this;
        synchronized (threadCounterMixin) {
            if (this._super_setFcStarted()) {
                this.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFcStopping(LifeCycleCoordinator coordinator) throws IllegalLifeCycleException {
        ThreadCounterMixin threadCounterMixin = this;
        synchronized (threadCounterMixin) {
            this._this_weaveableLCCLogger.log(BasicLevel.DEBUG, (Object)"Stopping component");
            this._this_weaveableFcState = 1;
            this.fcCoordinator = coordinator;
            if (!this._this_isInactivated(coordinator)) {
                for (int i = 0; i < this.fcExecutingThreads.length; ++i) {
                    if (this.fcExecutingThreads[i] == null) continue;
                    this.fcExecutingThreads[i].interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFcStopped() throws IllegalLifeCycleException {
        ThreadCounterMixin threadCounterMixin = this;
        synchronized (threadCounterMixin) {
            if (this._super_setFcStopped()) {
                this.fcCoordinator = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCurrentThread(String s) {
        ThreadCounterMixin threadCounterMixin = this;
        synchronized (threadCounterMixin) {
            if (this._this_weaveableFcState != 2) {
                boolean ok;
                do {
                    ok = this._this_weaveableFcState == 0 ? false : (this._this_weaveableFcState == 1 ? (this.fcNbExcutingThread == 0 ? this.fcCoordinator.fcActivated(this._this_getFcCoordinator()) : true) : true);
                    if (ok) continue;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (!ok);
            }
            return this.registerCurrentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCurrentThread(String s, int i) {
        ThreadCounterMixin threadCounterMixin = this;
        synchronized (threadCounterMixin) {
            this.unregisterCurrentThread(i);
        }
    }

    public int registerCurrentThread() {
        int freeIndex = -1;
        Thread currentThread = Thread.currentThread();
        for (int i = 0; i < this.fcExecutingThreads.length; ++i) {
            Thread thread = this.fcExecutingThreads[i];
            if (thread == currentThread) {
                int n = i;
                this.fcInvocationCounters[n] = this.fcInvocationCounters[n] + 1;
                return i;
            }
            if (thread != null) continue;
            freeIndex = i;
        }
        if (freeIndex == -1) {
            Thread[] precThreads = this.fcExecutingThreads;
            int[] precCounters = this.fcInvocationCounters;
            this.fcExecutingThreads = new Thread[precThreads.length + 2];
            this.fcInvocationCounters = new int[precThreads.length + 2];
            System.arraycopy(precThreads, 0, this.fcExecutingThreads, 0, precThreads.length);
            System.arraycopy(precCounters, 0, this.fcInvocationCounters, 0, precCounters.length);
            freeIndex = precThreads.length;
        }
        this.fcExecutingThreads[freeIndex] = currentThread;
        this.fcInvocationCounters[freeIndex] = 1;
        ++this.fcNbExcutingThread;
        return freeIndex;
    }

    public void unregisterCurrentThread(int i) {
        int n = i;
        this.fcInvocationCounters[n] = this.fcInvocationCounters[n] - 1;
        if (this.fcInvocationCounters[i] == 0) {
            this.fcExecutingThreads[i] = null;
            --this.fcNbExcutingThread;
            this._this_isInactivated(this.fcCoordinator);
        }
    }

    public boolean checkInactivity() {
        return this._this_weaveableFcState != 2 && this.fcNbExcutingThread == 0 && this._super_checkInactivity();
    }

    public abstract boolean _super_setFcStarted() throws IllegalLifeCycleException;

    public abstract boolean _super_setFcStopped() throws IllegalLifeCycleException;

    public abstract boolean _super_checkInactivity();

    public abstract LifeCycleCoordinator _this_getFcCoordinator();

    public abstract boolean _this_isInactivated(LifeCycleCoordinator var1);

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

