/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.message;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.dream.message.Chunk;
import org.objectweb.dream.message.ChunkAlreadyExistsException;
import org.objectweb.dream.message.ChunkType;
import org.objectweb.dream.message.ExtensibleMessage;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.MessageType;
import org.objectweb.dream.util.EmptyIterator;
import org.objectweb.dream.util.EmptyStringArray;

public abstract class AbstractExtensibleMessage
implements ExtensibleMessage,
MessageType,
EmptyStringArray,
Serializable {
    protected transient short messageManagerId;
    transient short referenceCounter = 0;
    protected Hashtable chunks = new Hashtable();
    protected Hashtable chunkTypes = new Hashtable();
    protected String[] chunkNames = null;

    public Object getChunk(String name) {
        return this.chunks.get(name);
    }

    public MessageType getMessageType() {
        return this;
    }

    public void transfertChunkStates(Message newInstance) {
        Iterator iter = this.chunks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            ((Chunk)e.getValue()).transfertState((Chunk)newInstance.getChunk((String)e.getKey()));
        }
    }

    public short getMessageManagerId() {
        return this.messageManagerId;
    }

    public void setMessageManagerId(short id) {
        this.messageManagerId = id;
    }

    public void recycle() {
        if (!this.chunks.isEmpty()) {
            System.err.println("WARNING : recycle not empty message");
            this.chunks.clear();
            this.chunkTypes.clear();
        }
    }

    public void addChunk(String name, ChunkType chkType, Object chunk) throws ChunkAlreadyExistsException {
        Object previousChunk = this.chunks.put(name, chunk);
        if (previousChunk != null) {
            this.chunks.put(name, previousChunk);
            throw new ChunkAlreadyExistsException();
        }
        this.chunkTypes.put(name, chkType);
        this.chunkNames = null;
    }

    public Object removeChunk(String name) {
        if (this.chunkTypes.remove(name) != null) {
            this.chunkNames = null;
        }
        return this.chunks.remove(name);
    }

    public String[] getChunkNames() {
        if (this.chunkNames == null) {
            this.chunkNames = this.chunks.isEmpty() ? EmptyStringArray.EMPTY_STRING_ARRAY : this.chunks.keySet().toArray(EmptyStringArray.EMPTY_STRING_ARRAY);
        }
        return this.chunkNames;
    }

    public Iterator getChunkNamesIterator() {
        if (this.chunks.isEmpty()) {
            return EmptyIterator.INSTANCE;
        }
        return this.chunks.keySet().iterator();
    }

    public ChunkType getChunkType(String name) {
        return (ChunkType)this.chunkTypes.get(name);
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public void incrementReferenceCounter() {
        this.referenceCounter = (short)(this.referenceCounter + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrementReferenceCounter() {
        AbstractExtensibleMessage abstractExtensibleMessage = this;
        synchronized (abstractExtensibleMessage) {
            this.referenceCounter = (short)(this.referenceCounter - 1);
            return this.referenceCounter == 0;
        }
    }
}

