/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.protocol.atomicity;

import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Pull;
import org.objectweb.dream.PullException;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.dream.protocol.atomicity.SetReactorThread;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public class AtomicReactorImpl
extends AbstractComponent
implements Push {
    public static final String INCOMMING_OUT_PUSH_ITF_NAME = "incomingOutPush";
    public static final String OUTGOING_OUT_PUSH_ITF_NAME = "outgoingOutPush";
    public static final String WAITING_PULL_ITF_NAME = "waitingPull";
    private Push incomingOutPushItf;
    private Push outgoingOutPushItf;
    private Pull waitingPullItf;
    private SetReactorThread setReactorThreadItf;
    private MessageManager messageManagerItf;
    private Thread previousReactorThread = null;

    public synchronized void push(Message message, Map context) throws PushException {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.previousReactorThread) {
            this.previousReactorThread = currentThread;
            this.setReactorThreadItf.setReactorThread(currentThread);
        }
        try {
            try {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Forward incoming message : " + message));
                }
                this.incomingOutPushItf.push(message, context);
            }
            catch (PushException e) {
                this.logger.log(BasicLevel.INFO, (Object)("Exception catched during reaction, emited messages are dropped. (message=" + message + ")"), e.getCause());
                Message msg = this.waitingPullItf.pull(null);
                while (msg != null) {
                    this.messageManagerItf.deleteMessage(msg);
                    msg = this.waitingPullItf.pull(null);
                }
            }
            Message msg = this.waitingPullItf.pull(null);
            while (msg != null) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Push outgoing message : " + message));
                this.outgoingOutPushItf.push(msg, null);
                msg = this.waitingPullItf.pull(null);
            }
        }
        catch (PullException e) {
            throw new PushException("An error occurs while pulling waiting messages", e);
        }
    }

    public String[] listFc() {
        return new String[]{OUTGOING_OUT_PUSH_ITF_NAME, INCOMMING_OUT_PUSH_ITF_NAME, WAITING_PULL_ITF_NAME, "setReactorThread", "message-manager"};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals(OUTGOING_OUT_PUSH_ITF_NAME)) {
            this.outgoingOutPushItf = (Push)serverItf;
        } else if (clientItfName.equals(INCOMMING_OUT_PUSH_ITF_NAME)) {
            this.incomingOutPushItf = (Push)serverItf;
        } else if (clientItfName.equals(WAITING_PULL_ITF_NAME)) {
            this.waitingPullItf = (Pull)serverItf;
        } else if (clientItfName.equals("setReactorThread")) {
            this.setReactorThreadItf = (SetReactorThread)serverItf;
        } else if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        }
    }
}

