/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.protocol.causality;

import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.ChunkAlreadyExistsException;
import org.objectweb.dream.message.ExtensibleMessage;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.dream.protocol.ArrowChunk;
import org.objectweb.dream.protocol.causality.CausalityChunk;
import org.objectweb.dream.protocol.causality.CausalityTransformerAttributeController;
import org.objectweb.dream.protocol.causality.MatrixClock;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutMessageStamperImpl
extends AbstractComponent
implements Push,
CausalityTransformerAttributeController {
    private MessageManager messageManagerItf;
    private MatrixClock matrixClockItf;
    private Push outPushItf;
    private String arrowChunkName;
    private String causalityChunkName;

    public void push(Message message, Map context) throws PushException {
        ArrowChunk arrowChunk = (ArrowChunk)message.getChunk(this.arrowChunkName);
        if (arrowChunk == null) {
            this.logger.log(BasicLevel.ERROR, (Object)("Unable to find arrow chunk named " + this.arrowChunkName + ". The message is dropped"));
            return;
        }
        CausalityChunk csltChunk = (CausalityChunk)message.getChunk(this.causalityChunkName);
        if (csltChunk == null) {
            if (message instanceof ExtensibleMessage) {
                csltChunk = (CausalityChunk)this.messageManagerItf.createChunk(CausalityChunk.TYPE);
                try {
                    ((ExtensibleMessage)message).addChunk(this.causalityChunkName, CausalityChunk.TYPE, csltChunk);
                }
                catch (ChunkAlreadyExistsException e) {}
            } else {
                this.logger.log(BasicLevel.ERROR, (Object)"Unable to find causality chunk in the unextensible message. The message is dropped");
                return;
            }
        }
        Object stamp = this.matrixClockItf.getStamp(arrowChunk.getProcessIdFrom(), arrowChunk.getProcessIdTo());
        csltChunk.setCausalityStamp(stamp);
        this.outPushItf.push(message, context);
    }

    public String getArrowChunkName() {
        return this.arrowChunkName;
    }

    public void setArrowChunkName(String arrowChunkName) {
        this.arrowChunkName = arrowChunkName;
    }

    public String getCausalityChunkName() {
        return this.causalityChunkName;
    }

    public void setCausalityChunkName(String causalityChunkName) {
        this.causalityChunkName = causalityChunkName;
    }

    public String[] listFc() {
        return new String[]{"out-push", "matrixClock", "message-manager"};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("matrixClock")) {
            this.matrixClockItf = (MatrixClock)serverItf;
        } else if (clientItfName.equals("out-push")) {
            this.outPushItf = (Push)serverItf;
        } else if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        }
    }
}

