/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.router;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class AbstractBasicRouterImpl
extends AbstractComponent
implements Push {
    protected Map outPushMap = new HashMap();
    public static final String DEFAULT_OUT_PUSH_ITF_NAME = "defaultOutPush";
    protected Push defaultOutPushItf = null;
    protected MessageManager messageManagerItf;
    protected boolean initialized = false;

    protected abstract Push getOutput(Message var1, Map var2) throws PushException;

    public void push(Message message, Map context) throws PushException {
        Push outPush = this.getOutput(message, context);
        if (outPush == null) {
            if (this.defaultOutPushItf == null) {
                this.logger.log(BasicLevel.ERROR, (Object)("No route for message " + message + ". The message will be dropped"));
                this.messageManagerItf.deleteMessage(message);
                return;
            }
            this.defaultOutPushItf.push(message, context);
        } else {
            outPush.push(message, context);
        }
    }

    public String[] listFc() {
        String[] tab = new String[this.outPushMap.size() + 1];
        this.outPushMap.keySet().toArray(tab);
        tab[this.outPushMap.size()] = "message-manager";
        return tab;
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.startsWith("out-push")) {
            this.outPushMap.put(clientItfName, serverItf);
            this.initialized = false;
        } else if (clientItfName.equals(DEFAULT_OUT_PUSH_ITF_NAME)) {
            this.defaultOutPushItf = (Push)serverItf;
            this.initialized = false;
        } else if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        }
    }

    public synchronized void unbindFc(String clientItfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.unbindFc(clientItfName);
        if (clientItfName.startsWith("out-push")) {
            this.outPushMap.remove(clientItfName);
            this.initialized = false;
        } else if (clientItfName.equals(DEFAULT_OUT_PUSH_ITF_NAME)) {
            this.defaultOutPushItf = null;
            this.initialized = false;
        }
    }
}

