/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.components;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.deployment.scheduling.component.api.InstanceProviderTask;
import org.objectweb.deployment.scheduling.component.lib.AbstractInitializationTask;
import org.objectweb.deployment.scheduling.component.lib.AbstractRequireInstanceProviderTask;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.TaskMap;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentBuilder;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentPair;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.api.control.BindingController;

public class PrimitiveComponentCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public ComponentBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (ComponentBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        InstanceProviderTask createTask = (InstanceProviderTask)tasks.getTask("create", container);
        StartTask startTask = new StartTask(this.builder);
        startTask.setInstanceProviderTask(createTask);
        tasks.addTask("start", container, startTask);
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            InstanceProviderTask createSubComponentTask = (InstanceProviderTask)tasks.getTask("create", comps[i]);
            ComponentPair pair = new ComponentPair(container, comps[i]);
            try {
                tasks.getTask("add", pair);
                continue;
            }
            catch (NoSuchElementException e) {
                AddTask addTask = new AddTask(this.builder, comps[i].getName());
                addTask.setInstanceProviderTask(createTask);
                addTask.setSubInstanceProviderTask(createSubComponentTask);
                tasks.addTask("add", pair, addTask);
            }
        }
    }

    static class StartTask
    extends AbstractInitializationTask {
        private ComponentBuilder builder;

        public StartTask(ComponentBuilder builder) {
            this.builder = builder;
        }

        public void execute(Object context) throws Exception {
            this.builder.startComponent(this.getInstanceProviderTask().getInstance(), context);
        }

        public String toString() {
            return "T" + System.identityHashCode(this) + "[StartTask()]";
        }
    }

    static class AddTask
    extends AbstractRequireInstanceProviderTask {
        private ComponentBuilder builder;
        private InstanceProviderTask subInstanceProviderTask;
        private String name;

        public AddTask(ComponentBuilder builder, String name) {
            this.builder = builder;
            this.name = name;
        }

        public InstanceProviderTask getSubInstanceProviderTask() {
            return this.subInstanceProviderTask;
        }

        public void setSubInstanceProviderTask(InstanceProviderTask task) {
            if (this.subInstanceProviderTask != null) {
                this.removePreviousTask(this.subInstanceProviderTask);
            }
            this.subInstanceProviderTask = task;
            if (this.subInstanceProviderTask != null) {
                this.addPreviousTask(this.subInstanceProviderTask);
            }
        }

        public void execute(Object context) throws Exception {
            Object parent = this.getInstanceProviderTask().getInstance();
            Object child = this.getSubInstanceProviderTask().getInstance();
            this.builder.addComponent(parent, child, this.name, context);
        }

        public Object getResult() {
            return null;
        }

        public void setResult(Object result) {
        }

        public String toString() {
            return "T" + System.identityHashCode(this) + "[AddTask(" + this.name + ")]";
        }
    }
}

