/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.objectweb.fractal.adl.Node;

public class XMLWriter {
    private Writer w;

    public XMLWriter(Writer writer) {
        this.w = writer;
    }

    public void write(Node node) throws IOException {
        this.write("", node);
    }

    private void write(String indent, Node node) throws IOException {
        this.w.write(indent);
        this.w.write(60);
        this.w.write(node.astGetType());
        Map attrs = node.astGetAttributes();
        for (String attr : attrs.keySet()) {
            String value = (String)attrs.get(attr);
            if (value == null) continue;
            this.w.write(32);
            this.w.write(attr);
            this.w.write("=\"");
            this.w.write(value);
            this.w.write("\"");
        }
        ArrayList<Node> subNodes = new ArrayList<Node>();
        String[] subNodeTypes = node.astGetNodeTypes();
        for (int j = 0; j < subNodeTypes.length; ++j) {
            Node[] nodes = node.astGetNodes(subNodeTypes[j]);
            for (int k = 0; k < nodes.length; ++k) {
                if (nodes[k] == null) continue;
                subNodes.add(nodes[k]);
            }
        }
        if (subNodes.size() > 0) {
            this.w.write(">\n");
            String subIndent = indent + "  ";
            for (int j = 0; j < subNodes.size(); ++j) {
                this.write(subIndent, (Node)subNodes.get(j));
            }
            this.w.write(indent);
            this.w.write("</");
            this.w.write(node.astGetType());
            this.w.write(">\n");
        } else {
            this.w.write("/>\n");
        }
    }
}

