/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.julia.ComponentInterface;
import org.objectweb.fractal.julia.Interceptor;

public abstract class BasicComponentInterface
implements ComponentInterface {
    protected Component owner;
    protected String name;
    protected Type type;
    protected int flags;

    public BasicComponentInterface() {
    }

    public BasicComponentInterface(Component owner, String name, Type type, boolean isInternal, Object impl) {
        boolean hasInterceptor = impl instanceof Interceptor;
        this.owner = owner == null ? (Component)((Object)this) : owner;
        this.name = name;
        this.type = type;
        this.flags = (isInternal ? 1 : 0) | (hasInterceptor ? 2 : 0);
        this.setFcItfImpl(impl);
    }

    public Component getFcItfOwner() {
        return this.owner;
    }

    public String getFcItfName() {
        return this.name;
    }

    public Type getFcItfType() {
        return this.type;
    }

    public boolean isFcInternalItf() {
        return (this.flags & 1) != 0;
    }

    public void setFcItfName(String name) {
        this.name = name;
    }

    public boolean hasFcInterceptor() {
        return (this.flags & 2) != 0;
    }

    public int hashCode() {
        return System.identityHashCode(this.getFcItfOwner()) * this.getFcItfName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Interface) {
            Interface itf = (Interface)o;
            return this.getFcItfOwner() == itf.getFcItfOwner() && this.getFcItfName().equals(itf.getFcItfName()) && this.isFcInternalItf() == itf.isFcInternalItf();
        }
        return false;
    }

    public Object clone() {
        BasicComponentInterface clone;
        try {
            clone = (BasicComponentInterface)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new Error("Internal error");
        }
        clone.owner = this.owner;
        clone.name = this.name;
        clone.type = this.type;
        clone.flags = this.flags;
        Object impl = this.getFcItfImpl();
        if (this.hasFcInterceptor()) {
            impl = ((Interceptor)impl).clone();
        }
        clone.setFcItfImpl(impl);
        return clone;
    }
}

