/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.asm;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.fractal.julia.asm.AbstractClassGenerator;
import org.objectweb.fractal.julia.asm.ClassGenerationException;
import org.objectweb.fractal.julia.asm.ClassTransformer;
import org.objectweb.fractal.julia.asm.CodeGenerator;
import org.objectweb.fractal.julia.asm.IllegalClassDescriptorException;
import org.objectweb.fractal.julia.asm.VisitException;
import org.objectweb.fractal.julia.loader.Initializable;
import org.objectweb.fractal.julia.loader.Loader;
import org.objectweb.fractal.julia.loader.Tree;

public class InterceptorClassGenerator
extends AbstractClassGenerator
implements Initializable {
    private static final List FRACTAL_METHODS = Arrays.asList("listFc", "lookupFc", "bindFc", "unbindFc", "getFcState", "startFc", "stopFc");
    public Tree args;
    public Tree codeGenDescs;
    public CodeGenerator[] codeGens;
    public ClassTransformer[] classTransformers;
    public Class[] controllerClasses;
    public boolean in;
    public boolean mergeInterceptors;
    public boolean mergeAll;
    public boolean isComposite;
    private boolean transformContentClass;
    private Class mergedControllerClass;
    private Class contentClass;
    public String implFieldName;
    public String implFieldDesc;
    static /* synthetic */ Class class$org$objectweb$fractal$api$control$ContentController;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$objectweb$fractal$julia$Interceptor;
    static /* synthetic */ Class class$org$objectweb$fractal$julia$InitializationContext;

    public void initialize(Tree args) {
        this.codeGenDescs = args;
    }

    public byte[] generateClass(String name, Tree args, Loader loader, ClassLoader classLoader) throws ClassGenerationException {
        this.args = args;
        this.superClass = args.getSubTree(1).toString().replace('.', '/');
        Tree controllerDescs = args.getSubTree(3);
        this.controllerClasses = new Class[controllerDescs.getSize()];
        for (int i = 0; i < this.controllerClasses.length; ++i) {
            try {
                this.controllerClasses[i] = loader.loadClass(controllerDescs.getSubTree(i), (Object)classLoader);
                continue;
            }
            catch (Exception e) {
                throw new ClassGenerationException(e, args.toString(), "Cannot load one of the controller class");
            }
        }
        boolean bl = this.mergeInterceptors = this.controllerClasses.length == 0;
        if (this.mergeInterceptors) {
            try {
                this.mergedControllerClass = loader.loadClass(args.getSubTree(1), (Object)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new ClassGenerationException(e, args.toString(), "Cannot load the '" + args.getSubTree(1) + "' class");
            }
            this.isComposite = (class$org$objectweb$fractal$api$control$ContentController == null ? (class$org$objectweb$fractal$api$control$ContentController = InterceptorClassGenerator.class$("org.objectweb.fractal.api.control.ContentController")) : class$org$objectweb$fractal$api$control$ContentController).isAssignableFrom(this.mergedControllerClass);
            this.contentClass = this.mergedControllerClass.getSuperclass();
            this.mergeAll = !this.contentClass.equals(class$java$lang$Object == null ? (class$java$lang$Object = InterceptorClassGenerator.class$("java.lang.Object")) : class$java$lang$Object);
        }
        this.in = args.getSubTree(4).toString().equals("in");
        ArrayList<Object> codeGenList = new ArrayList<Object>();
        ArrayList<Object> classTransformList = new ArrayList<Object>();
        for (int i = 0; i < this.codeGenDescs.getSize(); ++i) {
            Object o;
            try {
                o = loader.newObject(this.codeGenDescs.getSubTree(i), classLoader);
            }
            catch (Exception e) {
                throw new ClassGenerationException(e, args.toString(), "Cannot find the '" + this.codeGenDescs.getSubTree(i) + "' code generator class");
            }
            if (o instanceof ClassTransformer) {
                classTransformList.add(o);
                continue;
            }
            if (o instanceof CodeGenerator) {
                int type = ((CodeGenerator)o).init(this);
                if (type != 2 && type == 0 != this.in) continue;
                codeGenList.add(o);
                continue;
            }
            throw new ClassGenerationException(null, args.toString(), this.codeGenDescs.getSubTree(i) + " is not a ClassTransformer or a CodeGenerator");
        }
        if (codeGenList.size() == 0) {
            throw new IllegalClassDescriptorException(args.toString(), "no applicable code generator");
        }
        this.codeGens = new CodeGenerator[codeGenList.size()];
        this.classTransformers = new ClassTransformer[classTransformList.size()];
        codeGenList.toArray(this.codeGens);
        classTransformList.toArray(this.classTransformers);
        if (this.classTransformers.length > 0) {
            if (!this.mergeAll) {
                throw new ClassGenerationException(null, args.toString(), "Class transformers cannot be used without the mergeControllersInterceptorsAndContent optimization option");
            }
            this.transformContentClass = true;
        }
        return super.generateClass(name, args, loader, classLoader);
    }

    protected void parseArgs(Tree args) {
        super.parseArgs(args);
        if (this.transformContentClass) {
            this.superClass = "java/lang/Object";
        }
    }

    protected boolean computeMaxs() {
        return true;
    }

    protected String getSource() {
        String s = this.interfaces.get(0).toString();
        if (s.lastIndexOf(47) != -1) {
            s = s.substring(s.lastIndexOf(47) + 1);
        }
        return "INTERCEPTOR[" + s + "]";
    }

    protected List getImplementedInterfaces() throws ClassGenerationException {
        List itfs = super.getImplementedInterfaces();
        if (this.transformContentClass) {
            for (int p = 0; p < 2; ++p) {
                Class<?>[] classes = p == 0 ? this.contentClass.getInterfaces() : this.mergedControllerClass.getInterfaces();
                for (int i = 0; i < classes.length; ++i) {
                    String s = Type.getInternalName(classes[i]);
                    if (itfs.contains(s)) continue;
                    itfs.add(s);
                }
            }
        } else if (!this.mergeInterceptors || this.isComposite) {
            itfs.add(Type.getInternalName(class$org$objectweb$fractal$julia$Interceptor == null ? (class$org$objectweb$fractal$julia$Interceptor = InterceptorClassGenerator.class$("org.objectweb.fractal.julia.Interceptor")) : class$org$objectweb$fractal$julia$Interceptor));
        }
        if (this.codeGens != null) {
            for (int cg = 0; cg < this.codeGens.length; ++cg) {
                List itfsCG = this.codeGens[cg].getImplementedInterfaces();
                for (int itf = 0; itf < itfsCG.size(); ++itf) {
                    String itfName = (String)itfsCG.get(itf);
                    if (itfs.contains(itfName)) continue;
                    itfs.add(itfName);
                }
            }
        }
        return itfs;
    }

    protected void generateConstructor() throws ClassGenerationException {
        if (this.transformContentClass) {
            return;
        }
        super.generateConstructor();
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", "(Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.superClass, "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "org/objectweb/fractal/julia/Interceptor", "setFcItfDelegate", "(Ljava/lang/Object;)V");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    protected void generateDefaultMethods() throws ClassGenerationException {
        int i;
        MethodVisitor mv;
        String mDesc;
        String mName;
        super.generateDefaultMethods();
        if (this.mergeInterceptors && !this.isComposite) {
            this.implFieldName = "fcContent";
            this.implFieldDesc = "Ljava/lang/Object;";
            return;
        }
        this.implFieldName = "impl";
        this.implFieldDesc = this.interfaces.size() == 1 ? "L" + (String)this.interfaces.get(0) + ";" : "Ljava/lang/Object;";
        FieldVisitor fv = this.cw.visitField(2, this.implFieldName, this.implFieldDesc, null, null);
        if (fv != null) {
            fv.visitEnd();
        }
        if (!this.mergeInterceptors || !this.isComposite) {
            mName = "initFcController";
            mDesc = "(" + Type.getDescriptor(class$org$objectweb$fractal$julia$InitializationContext == null ? (class$org$objectweb$fractal$julia$InitializationContext = InterceptorClassGenerator.class$("org.objectweb.fractal.julia.InitializationContext")) : class$org$objectweb$fractal$julia$InitializationContext) + ")V";
            mv = this.cw.visitMethod(1, mName, mDesc, null, null);
            mv.visitCode();
            for (i = 0; i < this.codeGens.length; ++i) {
                this.codeGens[i].generateInitCode(mv);
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        mName = "getFcItfDelegate";
        mDesc = "()Ljava/lang/Object;";
        mv = this.cw.visitMethod(1, mName, mDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.name, this.implFieldName, this.implFieldDesc);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mName = "setFcItfDelegate";
        mDesc = "(Ljava/lang/Object;)V";
        mv = this.cw.visitMethod(1, mName, mDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        if (this.interfaces.size() == 1) {
            mv.visitTypeInsn(192, (String)this.interfaces.get(0));
        }
        mv.visitFieldInsn(181, this.name, this.implFieldName, this.implFieldDesc);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mName = "clone";
        mDesc = "()Ljava/lang/Object;";
        mv = this.cw.visitMethod(1, mName, mDesc, null, null);
        mv.visitCode();
        if (this.mergeInterceptors) {
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn("Cannot use merged interceptors with collection interfaces");
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
            mv.visitMaxs(2, 2);
        } else {
            mv.visitTypeInsn(187, this.name);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "org/objectweb/fractal/julia/Interceptor", "getFcItfDelegate", "()Ljava/lang/Object;");
            mv.visitMethodInsn(183, this.name, "<init>", "(Ljava/lang/Object;)V");
            mv.visitVarInsn(58, 1);
            for (i = 0; i < this.codeGens.length; ++i) {
                this.codeGens[i].generateCloneCode(mv);
            }
            mv.visitVarInsn(25, 1);
            mv.visitInsn(176);
            mv.visitMaxs(2, 2);
        }
        mv.visitEnd();
    }

    protected void generateInterfaceMethods() throws ClassGenerationException {
        if (this.transformContentClass) {
            HashMap<String, Method> methods = new HashMap<String, Method>();
            for (int i = 0; i < this.interfaces.size(); ++i) {
                Class itf;
                String s = ((String)this.interfaces.get(i)).replace('/', '.');
                try {
                    itf = this.loader.loadClass(s, (Object)this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassGenerationException(e, this.parameters, "Cannot load the '" + s + "' interface");
                }
                Method[] meths = itf.getMethods();
                for (int j = 0; j < meths.length; ++j) {
                    Method meth = meths[j];
                    String desc = meth.getName() + Type.getMethodDescriptor(meth);
                    methods.put(desc, meth);
                }
            }
            ClassVisitor cv = new FilterClassAdapter(methods, this.cw);
            for (int i = this.classTransformers.length - 1; i >= 0; --i) {
                this.classTransformers[i].setClassVisitor(cv);
                cv = this.classTransformers[i];
            }
            try {
                this.getClassReader(this.contentClass).accept(cv, false);
            }
            catch (IOException e) {
                throw new ClassGenerationException(e, this.args.toString(), "Cannot read the '" + this.contentClass.getName() + "' class");
            }
            catch (VisitException e) {
                throw e.getException();
            }
            cv = new FilterClassAdapter(null, this.cw);
            try {
                this.getClassReader(this.mergedControllerClass).accept(cv, false);
            }
            catch (IOException e) {
                throw new ClassGenerationException(e, this.args.toString(), "Cannot read the '" + this.mergedControllerClass.getName() + "' class");
            }
            catch (VisitException e) {
                throw e.getException();
            }
        }
        super.generateInterfaceMethods();
        for (int i = 0; i < this.codeGens.length; ++i) {
            this.codeGens[i].close();
        }
    }

    protected void generateMethod(Method m) throws ClassGenerationException {
        String itf = Type.getInternalName(m.getDeclaringClass());
        String mName = m.getName();
        String mDesc = Type.getMethodDescriptor(m);
        Class<?>[] params = m.getParameterTypes();
        Class<?> result = m.getReturnType();
        Class<?>[] exceptions = m.getExceptionTypes();
        String[] excepts = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            excepts[i] = Type.getInternalName(exceptions[i]);
        }
        MethodVisitor mv = this.cw.visitMethod(1, mName, mDesc, null, excepts);
        mv.visitCode();
        for (int i = 0; i < this.codeGens.length; ++i) {
            mv = this.codeGens[i].generateInterceptionCode(m, mv);
        }
        mv.visitVarInsn(25, 0);
        if (!this.mergeAll) {
            mv.visitFieldInsn(180, this.name, this.implFieldName, this.implFieldDesc);
            if (this.interfaces.size() > 1 || !this.superClass.equals("java/lang/Object")) {
                mv.visitTypeInsn(192, itf);
            }
        }
        int offset = 1;
        for (int i = 0; i < params.length; ++i) {
            mv.visitVarInsn(21 + InterceptorClassGenerator.getOpcodeOffset(params[i]), offset);
            offset += InterceptorClassGenerator.getSize(params[i]);
        }
        if (this.mergeAll) {
            mv.visitMethodInsn(183, this.superClass, mName, mDesc);
        } else {
            mv.visitMethodInsn(185, itf, mName, mDesc);
        }
        if (result == Void.TYPE) {
            mv.visitInsn(177);
        } else {
            mv.visitInsn(172 + InterceptorClassGenerator.getOpcodeOffset(result));
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private ClassReader getClassReader(Class c) throws IOException {
        try {
            return new ClassReader(c.getName());
        }
        catch (IOException e) {
            String s = Type.getInternalName(c) + ".class";
            return new ClassReader(c.getClassLoader().getResourceAsStream(s));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FilterCodeAdapter
    extends MethodAdapter {
        private List oldNames;

        public FilterCodeAdapter(List oldNames, MethodVisitor mv) {
            super(mv);
            this.oldNames = oldNames;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String newOwner = owner;
            if (this.oldNames.contains(owner)) {
                newOwner = InterceptorClassGenerator.this.name;
            }
            this.mv.visitFieldInsn(opcode, newOwner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String newOwner = owner;
            String newName = name;
            if (this.oldNames.contains(owner)) {
                newOwner = InterceptorClassGenerator.this.name;
            }
            if (this.oldNames.size() == 2 && owner.equals(this.oldNames.get(0)) && FRACTAL_METHODS.contains(name)) {
                newName = "super$" + name;
            }
            this.mv.visitMethodInsn(opcode, newOwner, newName, desc);
        }
    }

    private class FilterClassAdapter
    extends ClassAdapter {
        private Map methods;
        private boolean content;
        private List oldNames;

        public FilterClassAdapter(Map methods, ClassVisitor cv) {
            super(cv);
            this.methods = methods;
            if (methods != null) {
                this.content = true;
                this.oldNames = Arrays.asList(Type.getInternalName(InterceptorClassGenerator.this.contentClass));
            } else {
                this.content = false;
                this.oldNames = Arrays.asList(Type.getInternalName(InterceptorClassGenerator.this.contentClass), Type.getInternalName(InterceptorClassGenerator.this.mergedControllerClass));
            }
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Method m;
            int newAccess = access;
            String newName = name;
            if (this.content) {
                if (FRACTAL_METHODS.contains(name)) {
                    newAccess = 2;
                    newName = "super$" + name;
                }
            } else if (name.equals("<init>") || name.equals("getFcGeneratorParameters")) {
                return null;
            }
            MethodVisitor v = this.cv.visitMethod(newAccess, newName, desc, signature, exceptions);
            if (this.content && (m = (Method)this.methods.get(name + desc)) != null) {
                for (int i = 0; i < InterceptorClassGenerator.this.codeGens.length; ++i) {
                    try {
                        v = InterceptorClassGenerator.this.codeGens[i].generateInterceptionCode(m, v);
                        continue;
                    }
                    catch (ClassGenerationException e) {
                        throw new VisitException(e);
                    }
                }
            }
            return new FilterCodeAdapter(this.oldNames, v);
        }

        public void visitEnd() {
        }
    }
}

