/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.asm;

import java.lang.reflect.Method;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public abstract class InterceptorCodeAdapter
extends MethodAdapter
implements Opcodes {
    public static final int EMPTY = 0;
    public static final int NORMAL = 1;
    public static final int FINALLY = 2;
    protected Method m;
    protected int nbFormals;
    protected int returnLocal;
    private int newLocals;
    private int postBlockType;
    protected Label postBlockLabel;

    public InterceptorCodeAdapter(MethodVisitor cv, Method m, int newLocals, int postBlockType) {
        super(cv);
        int parameterSize = 1;
        Class<?>[] formals = m.getParameterTypes();
        for (int i = 0; i < formals.length; ++i) {
            if (formals[i] == Long.TYPE || formals[i] == Double.TYPE) {
                parameterSize += 2;
                continue;
            }
            ++parameterSize;
        }
        Class<?> result = m.getReturnType();
        int returnSize = result == Long.TYPE || result == Double.TYPE ? 2 : (result != Void.TYPE ? 1 : 0);
        this.m = m;
        this.nbFormals = parameterSize;
        this.returnLocal = parameterSize + newLocals;
        this.newLocals = newLocals + returnSize;
        this.postBlockType = postBlockType;
        this.postBlockLabel = new Label();
    }

    public void visitInsn(int opcode) {
        if (this.postBlockType == 0) {
            this.mv.visitInsn(opcode);
            return;
        }
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                int opcOffset = opcode - 172;
                this.mv.visitVarInsn(54 + opcOffset, this.returnLocal);
                if (this.postBlockType == 1) {
                    this.mv.visitJumpInsn(167, this.postBlockLabel);
                    break;
                }
                this.mv.visitJumpInsn(168, this.postBlockLabel);
                this.mv.visitVarInsn(21 + opcOffset, this.returnLocal);
                this.mv.visitInsn(opcode);
                break;
            }
            case 177: {
                if (this.postBlockType == 1) {
                    this.mv.visitJumpInsn(167, this.postBlockLabel);
                    break;
                }
                this.mv.visitJumpInsn(168, this.postBlockLabel);
                this.mv.visitInsn(177);
                break;
            }
            default: {
                this.mv.visitInsn(opcode);
            }
        }
    }

    public void visitVarInsn(int opcode, int var) {
        this.mv.visitVarInsn(opcode, var >= this.nbFormals ? var + this.newLocals : var);
    }

    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(var >= this.nbFormals ? var + this.newLocals : var, increment);
    }

    protected void generateReturnCode() {
        Class<?> c = this.m.getReturnType();
        if (c.isPrimitive()) {
            if (c == Void.TYPE) {
                this.mv.visitInsn(177);
            } else if (c == Long.TYPE) {
                this.mv.visitVarInsn(22, this.returnLocal);
                this.mv.visitInsn(173);
            } else if (c == Float.TYPE) {
                this.mv.visitVarInsn(23, this.returnLocal);
                this.mv.visitInsn(174);
            } else if (c == Double.TYPE) {
                this.mv.visitVarInsn(24, this.returnLocal);
                this.mv.visitInsn(175);
            } else {
                this.mv.visitVarInsn(21, this.returnLocal);
                this.mv.visitInsn(172);
            }
        } else {
            this.mv.visitVarInsn(25, this.returnLocal);
            this.mv.visitInsn(176);
        }
    }
}

