/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.type;

import java.io.Serializable;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.ChainedNoSuchInterfaceException;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;

public class BasicComponentType
implements ComponentType,
Serializable {
    private final InterfaceType[] interfaceTypes;

    public BasicComponentType(InterfaceType[] itfTypes) throws InstantiationException {
        this.interfaceTypes = BasicComponentType.clone(itfTypes);
        for (int i = 0; i < this.interfaceTypes.length; ++i) {
            String p = this.interfaceTypes[i].getFcItfName();
            boolean collection = this.interfaceTypes[i].isFcCollectionItf();
            for (int j = i + 1; j < this.interfaceTypes.length; ++j) {
                String q = this.interfaceTypes[j].getFcItfName();
                if (p.equals(q)) {
                    throw new ChainedInstantiationException(null, null, "Two interfaces have the same name '" + q + "'");
                }
                if (collection && q.startsWith(p)) {
                    throw new ChainedInstantiationException(null, null, "The name of the interface '" + q + "' starts with '" + p + "', which is the name of a collection interface");
                }
                if (!this.interfaceTypes[j].isFcCollectionItf() || !p.startsWith(q)) continue;
                throw new ChainedInstantiationException(null, null, "The name of the interface '" + p + "' starts with '" + q + "', which is the name of a collection interface");
            }
        }
    }

    public InterfaceType[] getFcInterfaceTypes() {
        return BasicComponentType.clone(this.interfaceTypes);
    }

    public InterfaceType getFcInterfaceType(String name) throws NoSuchInterfaceException {
        for (int i = 0; i < this.interfaceTypes.length; ++i) {
            InterfaceType itfType = this.interfaceTypes[i];
            String itfName = itfType.getFcItfName();
            if (!(itfType.isFcCollectionItf() ? name.startsWith(itfName) : name.equals(itfName))) continue;
            return itfType;
        }
        throw new ChainedNoSuchInterfaceException(null, null, name);
    }

    public boolean isFcSubTypeOf(Type type) {
        try {
            if (type instanceof ComponentType) {
                int i;
                ComponentType t = (ComponentType)type;
                InterfaceType[] itfs = this.interfaceTypes;
                for (i = 0; i < itfs.length; ++i) {
                    InterfaceType i2;
                    InterfaceType i1 = itfs[i];
                    if (!i1.isFcClientItf() || i1.isFcSubTypeOf(i2 = t.getFcInterfaceType(i1.getFcItfName()))) continue;
                    return false;
                }
                itfs = t.getFcInterfaceTypes();
                for (i = 0; i < itfs.length; ++i) {
                    InterfaceType i1;
                    InterfaceType i2 = itfs[i];
                    if (i2.isFcClientItf() || (i1 = this.getFcInterfaceType(i2.getFcItfName())).isFcSubTypeOf(i2)) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return false;
    }

    private static InterfaceType[] clone(InterfaceType[] types) {
        if (types == null) {
            return new InterfaceType[0];
        }
        InterfaceType[] clone = new InterfaceType[types.length];
        System.arraycopy(types, 0, clone, 0, types.length);
        return clone;
    }
}

