/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.cartography.linux;

import org.apache.log4j.Logger;
import org.objectweb.lewys.cartography.linux.Probe_SoftwareElement;
import org.objectweb.lewys.cartography.linux.helpers.Tools;
import org.objectweb.lewys.cartography.linux.helpers.file.etc.Grub;
import org.objectweb.lewys.cartography.linux.helpers.file.proc.Sys;
import org.objectweb.lewys.cartography.linux.helpers.file.proc.Version;
import org.objectweb.lewys.repository.cim.CIM_ManagedSystemElement;
import org.objectweb.lewys.repository.cim.CIM_OperatingSystem;

public class Probe_OperatingSystem
extends Probe_SoftwareElement {
    private static Logger logger = Logger.getLogger(Probe_OperatingSystem.class);

    public CIM_ManagedSystemElement[] get() {
        int i;
        String[][] listOS = Grub.fetch();
        CIM_ManagedSystemElement[] OS = null;
        String[] temp = null;
        if (listOS == null) {
            OS = new CIM_OperatingSystem[]{new CIM_OperatingSystem()};
            OS[0].Name = Version.getOsName();
            OS[0].Release = Sys.getOsRelease();
            ((CIM_OperatingSystem)OS[0]).Version = Sys.getOsVersion();
            ((CIM_OperatingSystem)OS[0]).OSType = Sys.getOsType();
        } else {
            OS = new CIM_OperatingSystem[listOS.length];
            for (i = 0; i < listOS.length; ++i) {
                OS[i] = new CIM_OperatingSystem();
                ((CIM_OperatingSystem)OS[i]).Name = listOS[i][0];
                ((CIM_OperatingSystem)OS[i]).Version = listOS[i][1];
                ((CIM_OperatingSystem)OS[i]).Root = listOS[i][2];
                ((CIM_OperatingSystem)OS[i]).Kernel = listOS[i][3];
                temp = Tools.listOfTokens(listOS[i][0], " ");
                ((CIM_OperatingSystem)OS[i]).OSType = temp[temp.length - 1];
                if (!Sys.getOsVersion().equals(((CIM_OperatingSystem)OS[i]).Version)) continue;
                ((CIM_OperatingSystem)OS[i]).Release = Sys.getOsRelease();
                ((CIM_OperatingSystem)OS[i]).OSType = Sys.getOsType();
            }
        }
        for (i = 0; i < OS.length; ++i) {
            logger.debug((Object)("Operating system " + i + ": \n" + ((CIM_OperatingSystem)OS[i]).toString()));
        }
        return OS;
    }
}

