/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.cartography.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.objectweb.lewys.cartography.linux.Probe_SoftwareElement;
import org.objectweb.lewys.cartography.linux.helpers.Tools;
import org.objectweb.lewys.cartography.linux.helpers.command.Rpm;
import org.objectweb.lewys.repository.cim.CIM_ManagedSystemElement;
import org.objectweb.lewys.repository.cim.CIM_RPMPackage;

public class Probe_RPMPackage
extends Probe_SoftwareElement {
    private static Logger logger = Logger.getLogger(Probe_RPMPackage.class);

    public CIM_ManagedSystemElement[] get() {
        int i;
        String[] listRPM = Rpm.getListOfRPMPackage();
        CIM_ManagedSystemElement[] rpms = new CIM_RPMPackage[listRPM.length];
        for (i = 0; i < listRPM.length; ++i) {
            rpms[i] = new CIM_RPMPackage();
            ((CIM_RPMPackage)rpms[i]).Name = listRPM[i];
            this.infoPackageRPM((CIM_RPMPackage)rpms[i]);
        }
        for (i = 0; i < rpms.length; ++i) {
            logger.debug((Object)("RPM Package " + i + ": \n" + ((CIM_RPMPackage)rpms[i]).toString()));
        }
        return rpms;
    }

    protected void infoPackageRPM(CIM_RPMPackage rpm) {
        String[] ligne = null;
        String temp = null;
        Process proc = null;
        boolean bool = false;
        try {
            proc = Runtime.getRuntime().exec("rpm -qi " + rpm.Name);
            BufferedReader resultat = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            temp = resultat.readLine();
            while (temp != null) {
                ligne = Tools.listOfTokens(temp, ": ");
                for (int i = 0; i < ligne.length; ++i) {
                    if (!bool) {
                        int j;
                        if (ligne[i].equals("Name")) {
                            rpm.Name = ligne[i + 1];
                            continue;
                        }
                        if (ligne[i].equals("Version")) {
                            rpm.Version = ligne[i + 1];
                            continue;
                        }
                        if (ligne[i].equals("Vendor")) {
                            rpm.Vendor = "";
                            for (j = i + 1; j < ligne.length; ++j) {
                                rpm.Vendor = rpm.Vendor + ligne[j] + " ";
                            }
                            break;
                        }
                        if (ligne[i].equals("Release")) {
                            rpm.Release = ligne[i + 1];
                            continue;
                        }
                        if (ligne[i].equals("Build") && ligne[i + 1].equals("Date")) {
                            rpm.BuildDate = "";
                            for (j = i + 2; j < ligne.length; ++j) {
                                rpm.BuildDate = rpm.BuildDate + ligne[j] + " ";
                            }
                            break;
                        }
                        if (ligne[i].equals("Install") && ligne[i + 1].equals("Date")) {
                            rpm.InstallDate = "";
                            for (j = i + 2; j < ligne.length && !ligne[j].equals("Build"); ++j) {
                                rpm.InstallDate = rpm.InstallDate + ligne[j] + " ";
                            }
                            continue;
                        }
                        if (ligne[i].equals("Group")) {
                            rpm.Groups = "";
                            for (j = i + 1; j < ligne.length && !ligne[j].equals("Source"); ++j) {
                                rpm.Groups = rpm.Groups + ligne[j] + " ";
                            }
                            continue;
                        }
                        if (ligne[i].equals("Build") && ligne[i + 1].equals("Host")) {
                            rpm.BuildHost = "";
                            for (j = i + 2; j < ligne.length; ++j) {
                                rpm.BuildHost = rpm.BuildHost + ligne[j] + " ";
                            }
                            break;
                        }
                        if (ligne[i].equals("Source") && ligne[i + 1].equals("RPM")) {
                            rpm.SourceRPM = ligne[i + 2];
                            continue;
                        }
                        if (ligne[i].equals("Size")) {
                            rpm.SizeKB = Integer.parseInt(ligne[i + 1]);
                            continue;
                        }
                        if (ligne[i].equals("License")) {
                            rpm.License = "";
                            for (j = i + 1; j < ligne.length; ++j) {
                                rpm.License = rpm.License + ligne[j] + " ";
                            }
                            break;
                        }
                        if (ligne[i].equals("Signature")) {
                            rpm.Signature = "";
                            for (j = i + 1; j < ligne.length; ++j) {
                                rpm.Signature = rpm.Signature + ligne[j] + " ";
                            }
                            break;
                        }
                        if (ligne[i].equals("Packager")) {
                            rpm.Packager = "";
                            for (j = i + 1; j < ligne.length; ++j) {
                                rpm.Packager = rpm.Packager + ligne[j] + " ";
                            }
                            break;
                        }
                        if (ligne[i].equals("Summary")) {
                            rpm.Caption = "";
                            for (j = i + 1; j < ligne.length; ++j) {
                                rpm.Caption = rpm.Caption + Tools.clean(ligne[j]) + " ";
                            }
                            break;
                        }
                        if (!ligne[i].equals("Description")) continue;
                        rpm.Description = "";
                        bool = true;
                        break;
                    }
                    rpm.Description = rpm.Description + Tools.clean(temp) + "\n";
                    break;
                }
                temp = resultat.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

