/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.filtering;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.BasicMessageType;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.MessageType;
import org.objectweb.dream.message.manager.BasicMessageManagerImpl;
import org.objectweb.lewys.common.exceptions.RepositoryException;
import org.objectweb.lewys.filtering.FilterManager;
import org.objectweb.lewys.message.MonitoringValueChunk;
import org.objectweb.lewys.repository.MonitoringRepositoryImpl;

public class FilterManagerDBClient {
    private MonitoringRepositoryImpl repository = new MonitoringRepositoryImpl();
    private Connection conn = this.repository.getConnection();
    private BasicMessageManagerImpl messageManager = new BasicMessageManagerImpl();
    private FilterManager filterManager;
    private static final MessageType TYPE = new BasicMessageType("monitoring-value-chunk", MonitoringValueChunk.TYPE);

    public void generateLoad() throws RepositoryException, PushException {
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<Integer> probe_resources = new ArrayList<Integer>();
        ResultSet rs = null;
        PreparedStatement selectStmt = null;
        try {
            selectStmt = this.conn.prepareStatement("SELECT distinct n.name FROM nodes n, pumps pu, probes pb, probe_resources pr, measurements1 m WHERE pu.node=n.id AND pb.pump=pu.id AND pr.probe=pb.id AND m.probe_resource=pr.id AND (m.filter_type=0 OR m.filter_type IS NULL)");
            rs = selectStmt.executeQuery();
            while (rs.next()) {
                nodes.add(rs.getString("name"));
            }
            rs.close();
            selectStmt.close();
            selectStmt = this.conn.prepareStatement("SELECT distinct probe_resource FROM measurements1 ");
            rs = selectStmt.executeQuery();
            while (rs.next()) {
                probe_resources.add(new Integer(rs.getInt("probe_resource")));
            }
            rs.close();
            selectStmt.close();
            for (int j = 0; j < probe_resources.size(); ++j) {
                for (int i = 0; i < 6; ++i) {
                    HashMap precisionWidthMap = this.createPrecisionWidthMap(nodes, i);
                    this.filterManager = new FilterManager();
                    try {
                        this.filterManager.bindFc("monitoring-repository", this.repository);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.filterManager.setPrecisionWidthMap(precisionWidthMap);
                    selectStmt = this.conn.prepareStatement("SELECT n.name as nodeName,pb.name as probeName,pr.resource_id,m.value,m.timestmp,m.sampling_freq FROM nodes n, pumps pu, probes pb, probe_resources pr, measurements1 m WHERE pu.node=n.id AND pb.pump=pu.id AND pr.probe=pb.id AND m.probe_resource=pr.id AND m.probe_resource=? AND (m.filter_type=0 OR m.filter_type IS NULL) ORDER BY m.timestmp", 1003, 1007);
                    selectStmt.setInt(1, (Integer)probe_resources.get(j));
                    selectStmt.setFetchSize(Integer.MIN_VALUE);
                    rs = selectStmt.executeQuery();
                    while (rs.next()) {
                        String nodeName = rs.getString("nodeName");
                        String probeName = rs.getString("probeName");
                        int resource_id = rs.getInt("resource_id");
                        long value = rs.getLong("value");
                        long timestamp = rs.getLong("timestmp");
                        long sampling_freq = rs.getLong("sampling_freq");
                        Message m = this.messageManager.createMessage(TYPE);
                        MonitoringValueChunk chunk = (MonitoringValueChunk)m.getChunk("monitoring-value-chunk");
                        chunk.setSenderName(nodeName);
                        chunk.setProbeName(probeName);
                        chunk.setResourceIds(new int[]{resource_id});
                        chunk.setValues(new long[]{value});
                        chunk.setTimestamp(timestamp);
                        this.filterManager.setSamplingFrequency(sampling_freq);
                        this.filterManager.push(m, null);
                        this.messageManager.deleteMessage(m);
                    }
                    rs.close();
                    selectStmt.close();
                    selectStmt = null;
                    this.repository.flushRequests();
                }
            }
            this.repository.shutDown();
        }
        catch (SQLException e) {
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new RepositoryException("Error while accessing database: " + e);
        }
    }

    public HashMap createPrecisionWidthMap(ArrayList nodes, int i) {
        HashMap<String, Double> precisiionWidthMap = new HashMap<String, Double>();
        for (int j = 0; j < nodes.size(); ++j) {
            Double precisionWidth;
            String key;
            int k;
            for (k = 0; k < 5; ++k) {
                key = (String)nodes.get(j) + ";" + "cpu probe" + ";" + 4 * k;
                precisionWidth = new Double((i + 1) * 25);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "cpu probe" + ";" + (4 * k + 1);
                precisionWidth = new Double((i + 1) * 25);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "cpu probe" + ";" + (4 * k + 2);
                precisionWidth = new Double((i + 1) * 25);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "cpu probe" + ";" + (4 * k + 3);
                precisionWidth = new Double((i + 1) * 25);
                precisiionWidthMap.put(key, precisionWidth);
            }
            for (k = 0; k < 12; ++k) {
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + 11 * k;
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 1);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 2);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 3);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 4);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 5);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 6);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 7);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 8);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 9);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "disk probe" + ";" + (11 * k + 10);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
            }
            for (k = 0; k < 1; ++k) {
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + 13 * k;
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 1);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 2);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 3);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 4);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 5);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 6);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 7);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 8);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 9);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 10);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 11);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "memory probe" + ";" + (13 * k + 12);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
            }
            for (k = 0; k < 5; ++k) {
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 0);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 1);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 2);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 3);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 4);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 5);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 6);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 7);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 8);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 9);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 10);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 11);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 12);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 13);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 14);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "network probe" + ";" + (16 * k + 15);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
            }
            for (k = 0; k < 1; ++k) {
                key = (String)nodes.get(j) + ";" + "kernel probe" + ";" + (3 * k + 0);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "kernel probe" + ";" + (3 * k + 1);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
                key = (String)nodes.get(j) + ";" + "kernel probe" + ";" + (3 * k + 2);
                precisionWidth = new Double((i + 1) * 1);
                precisiionWidthMap.put(key, precisionWidth);
            }
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "0";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "1";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "2";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "3";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "4";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "5";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "6";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "7";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "8";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "9";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "10";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "11";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "12";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "13";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "14";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "15";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "16";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
            key = (String)nodes.get(j) + ";" + "cjdbc probe" + ";" + "17";
            precisionWidth = new Double((i + 1) * 1);
            precisiionWidthMap.put(key, precisionWidth);
        }
        return precisiionWidthMap;
    }

    public static void main(String[] args) {
        try {
            FilterManagerDBClient generator = new FilterManagerDBClient();
            generator.generateLoad();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

