/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.Iterator;
import org.objectweb.dream.channel.IPChannelDestinationChunk;
import org.objectweb.dream.message.AbstractNonExtensibleMessage;
import org.objectweb.dream.message.ChunkType;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.MessageType;
import org.objectweb.dream.util.ArrayIterator;
import org.objectweb.dream.util.Util;
import org.objectweb.lewys.message.MonitoringValueChunk;

public class MonitoringMessage
extends AbstractNonExtensibleMessage
implements Message,
MessageType,
MonitoringValueChunk,
IPChannelDestinationChunk,
Externalizable {
    public static final MessageType TYPE = new MonitoringMessage();
    private static final String MONITORING_VALUE_CHUNK_NAME = "monitoring-value-chunk";
    private static final String IP_CHANNEL_DESTINATION_CHUNK_NAME = "IPChannelDestination";
    private static final String[] CHUNK_NAMES = new String[]{"IPChannelDestination"};
    private String probeName;
    private int[] resourceIds;
    private long[] values;
    private long timestamp;
    private String senderName;
    private transient InetAddress addr;
    private transient int port;

    public String getProbeName() {
        return this.probeName;
    }

    public int[] getResourceIds() {
        return this.resourceIds;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long[] getValues() {
        return this.values;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setProbeName(String probeName) {
        this.probeName = probeName;
    }

    public void setResourceIds(int[] resourceIds) {
        this.resourceIds = resourceIds;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setValues(long[] values) {
        this.values = values;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public InetAddress getChannelDestinationAddr() {
        return this.addr;
    }

    public void setChannelDestinationAddr(InetAddress addr) {
        this.addr = addr;
    }

    public int getChannelDestinationPort() {
        return this.port;
    }

    public void setChannelDestinationPort(int port) {
        this.port = port;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.probeName);
        Util.writeExternalIntArray(out, this.resourceIds);
        Util.writeExternalLongArray(out, this.values);
        out.writeLong(this.timestamp);
        out.writeUTF(this.senderName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.probeName = in.readUTF();
        this.resourceIds = Util.readExternalIntArray(in);
        this.values = Util.readExternalLongArray(in);
        this.timestamp = in.readLong();
        this.senderName = in.readUTF();
    }

    public void transfertChunkStates(Message newInstance) {
        MonitoringValueChunk newInst = (MonitoringValueChunk)((Object)newInstance);
        newInst.setProbeName(this.getProbeName());
        newInst.setResourceIds(this.getResourceIds());
        newInst.setTimestamp(this.getTimestamp());
        newInst.setValues(this.getValues());
        newInst.setSenderName(this.getSenderName());
    }

    public void recycle() {
        this.probeName = null;
        this.resourceIds = null;
        this.values = null;
        this.timestamp = -1L;
        this.addr = null;
        this.port = -1;
        this.senderName = null;
    }

    public ChunkType getChunkType(String name) {
        if (name.equals(MONITORING_VALUE_CHUNK_NAME)) {
            return MonitoringValueChunk.TYPE;
        }
        if (name.equals(IP_CHANNEL_DESTINATION_CHUNK_NAME)) {
            return IPChannelDestinationChunk.TYPE;
        }
        return null;
    }

    public String[] getChunkNames() {
        return CHUNK_NAMES;
    }

    public Iterator getChunkNamesIterator() {
        return new ArrayIterator(CHUNK_NAMES);
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isSubTypeOf(MessageType t) {
        return false;
    }
}

