/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.jmx.cjdbc;

import java.io.IOException;
import java.util.ArrayList;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.jmx.cjdbc.CjdbcJmxClient;
import org.objectweb.lewys.probe.jmx.cjdbc.CjdbcProbeCompletion;
import org.objectweb.lewys.probe.jmx.cjdbc.CjdbcProbeThread;

public class CjdbcProbe
extends AbstractProbe {
    public static final int NB_OF_CONTROLLER_RESOURCES = 5;
    public static final int NB_OF_VIRTUAL_DB_RESOURCES = 13;
    public static final int NB_OF_THREADS = 2;
    private long[] resourceValues;
    private CjdbcJmxClient jmxClient;
    private String[] virtualDBNames;
    private String[] virtualDBResourceNames;
    private int[] virtualDBResourceIds;
    private String[] controllerResourceNames;
    private int[] controllerResourceIds;
    private CjdbcProbeThread[] threads;
    public ArrayList jobs;
    public CjdbcProbeCompletion completion;

    public CjdbcProbe() throws NoResourceToProbeException {
        super("cjdbc probe");
        int i;
        String port = "1090";
        String host = "localhost";
        String[] credentials = new String[]{"admin", ""};
        try {
            this.jmxClient = new CjdbcJmxClient(port, host, credentials);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NoResourceToProbeException(e);
        }
        this.virtualDBNames = this.retreiveVirtualDBNames();
        this.resourceIds = new int[5 + 13 * this.virtualDBNames.length];
        this.resourceNames = new String[5 + 13 * this.virtualDBNames.length];
        this.resourceValues = new long[5 + 13 * this.virtualDBNames.length];
        for (int i2 = 0; i2 < this.resourceIds.length; ++i2) {
            this.resourceIds[i2] = i2;
        }
        this.controllerResourceNames = new String[]{"Controller total memory", "Controller used memory", "Controller Worker Threads Number", "Controller Worker Pending Queue", "Controller Idle Worker Threads"};
        this.controllerResourceIds = new int[]{40, 41, 42, 43, 44};
        this.virtualDBResourceNames = new String[]{"Databases active threads", "Databases pending connections", "Databases number of threads", "Cache stats count select", "Cache stats count hits", "Cache stats count insert", "Cache stats hits percentage", "Cache stats number entries", "Scheduler number read", "Scheduler number writes", "Scheduler pending transactions", "Scheduler pending writes", "Scheduler number requests"};
        this.virtualDBResourceIds = new int[]{50, 51, 52, 20, 21, 22, 23, 24, 60, 61, 62, 63, 64};
        int k = 0;
        for (i = 0; i < 5; ++i) {
            this.resourceNames[k++] = this.controllerResourceNames[i];
        }
        for (i = 0; i < this.virtualDBNames.length; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.resourceNames[k++] = this.virtualDBNames[i] + " " + this.virtualDBResourceNames[j];
            }
        }
        this.jobs = new ArrayList();
        this.threads = null;
        this.initThreads(2);
    }

    public void initThreads(int n) throws NoResourceToProbeException {
        if (this.threads != null) {
            this.killThreads();
        }
        this.threads = new CjdbcProbeThread[n];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new CjdbcProbeThread(this);
            this.threads[i].start();
        }
    }

    public void killThreads() {
        for (int i = 0; i < this.threads.length; ++i) {
            try {
                this.threads[i].setKilled(true);
                this.threads[i].interrupt();
                this.threads[i].join();
                continue;
            }
            catch (InterruptedException ie) {
                System.err.println("ClientEmulator: Thread " + i + " has been interrupted.");
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] <= this.resourceIds.length) continue;
            throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid" + ". Resource ID superior to MaxID=" + this.resourceIds.length);
        }
        this.getCjdbcUsage(resourceIds);
        long[] result = new long[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            result[i] = this.resourceValues[resourceIds[i]];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCjdbcUsage(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.completion = new CjdbcProbeCompletion(resourceIds.length, 0);
        Object object = this.jobs;
        synchronized (object) {
            for (int i = 0; i < resourceIds.length; ++i) {
                this.jobs.add(new Integer(resourceIds[i]));
            }
            this.jobs.notifyAll();
        }
        try {
            object = this.completion;
            synchronized (object) {
                if (!this.completion.isCompleted()) {
                    this.completion.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            System.err.println("CjdbcProbe main thead has been interrupted.");
        }
    }

    private String[] retreiveVirtualDBNames() throws NoResourceToProbeException {
        String[] names = null;
        try {
            ArrayList namesArray = this.jmxClient.getControllerProxy().getVirtualDatabaseNames();
            names = new String[namesArray.size()];
            for (int i = 0; i < namesArray.size(); ++i) {
                names[i] = (String)namesArray.get(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoResourceToProbeException(e);
        }
        return names;
    }

    public CjdbcJmxClient getJmxClient() {
        return this.jmxClient;
    }

    public int[] getControllerResourceIds() {
        return this.controllerResourceIds;
    }

    public String[] getControllerResourceNames() {
        return this.controllerResourceNames;
    }

    public int[] getVirtualDBResourceIds() {
        return this.virtualDBResourceIds;
    }

    public String[] getVirtualDBResourceNames() {
        return this.virtualDBResourceNames;
    }

    public String[] getVirtualDBNames() {
        return this.virtualDBNames;
    }

    public synchronized void setResourceValue(int index, long resourceValue) {
        this.resourceValues[index] = resourceValue;
    }
}

