/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.macosx;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class CpuProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESOURCES = 4;
    private static final int CPU_USER_RES = 0;
    private static final int CPU_NICE_RES = 1;
    private static final int CPU_SYS_RES = 2;
    private static final int CPU_IDLE_RES = 3;
    private long[] cpuUser;
    private long[] cpuNice;
    private long[] cpuSys;
    private long[] cpuIdle;
    private int nbOfCpus = 0;

    public CpuProbe() throws NoResourceToProbeException {
        super("cpu probe");
        int i;
        try {
            long[] load = this.getCpuLoad();
            this.nbOfCpus = load.length / 4 + 1;
        }
        catch (ProbeException ex) {
            throw new NoResourceToProbeException();
        }
        this.cpuUser = new long[this.nbOfCpus];
        this.cpuNice = new long[this.nbOfCpus];
        this.cpuSys = new long[this.nbOfCpus];
        this.cpuIdle = new long[this.nbOfCpus];
        this.resourceNames = new String[this.nbOfCpus * 4];
        this.resourceNames[0] = "cpu user";
        this.resourceNames[1] = "cpu nice";
        this.resourceNames[2] = "cpu kernel";
        this.resourceNames[3] = "cpu idle";
        for (i = 1; i < this.nbOfCpus; ++i) {
            this.resourceNames[i * 4 + 0] = "cpu" + (i - 1) + " user";
            this.resourceNames[i * 4 + 1] = "cpu" + (i - 1) + " nice";
            this.resourceNames[i * 4 + 2] = "cpu" + (i - 1) + " kernel";
            this.resourceNames[i * 4 + 3] = "cpu" + (i - 1) + " idle";
        }
        this.resourceIds = new int[this.resourceNames.length];
        for (i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getCpuUsage();
        long[] result = new long[resourceIds.length];
        block6: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 4 * this.nbOfCpus) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int cpu = resourceIds[i] / 4;
            switch (resourceIds[i] % 4) {
                case 0: {
                    result[i] = this.cpuUser[cpu];
                    continue block6;
                }
                case 1: {
                    result[i] = this.cpuNice[cpu];
                    continue block6;
                }
                case 2: {
                    result[i] = this.cpuSys[cpu];
                    continue block6;
                }
                case 3: {
                    result[i] = this.cpuIdle[cpu];
                    continue block6;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    private void getCpuUsage() throws ProbeException {
        int cpu;
        long[] load = this.getCpuLoad();
        if (load.length != (this.nbOfCpus - 1) * 4) {
            throw new ProbeException("Internal error!");
        }
        for (cpu = 1; cpu < this.nbOfCpus; ++cpu) {
            this.cpuUser[cpu] = load[(cpu - 1) * 4 + 0];
            this.cpuNice[cpu] = load[(cpu - 1) * 4 + 1];
            this.cpuSys[cpu] = load[(cpu - 1) * 4 + 2];
            this.cpuIdle[cpu] = load[(cpu - 1) * 4 + 3];
        }
        this.cpuUser[0] = 0L;
        this.cpuNice[0] = 0L;
        this.cpuSys[0] = 0L;
        this.cpuIdle[0] = 0L;
        for (cpu = 1; cpu < this.nbOfCpus; ++cpu) {
            this.cpuUser[0] = this.cpuUser[0] + this.cpuUser[cpu];
            this.cpuNice[0] = this.cpuNice[0] + this.cpuNice[cpu];
            this.cpuSys[0] = this.cpuSys[0] + this.cpuSys[cpu];
            this.cpuIdle[0] = this.cpuIdle[0] + this.cpuIdle[cpu];
        }
    }

    private native long[] getCpuLoad() throws ProbeException;

    static {
        System.loadLibrary("LeWYS");
    }
}

