/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.macosx;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class NetworkProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESOURCES = 17;
    private static final int BYTES_RECEIVED_RES = 0;
    private static final int PACKETS_RECEIVED_RES = 1;
    private static final int ERRORS_RECEIVED_RES = 2;
    private static final int DROP_RECEIVED_RES = 3;
    private static final int FIFO_RECEIVED_RES = 4;
    private static final int FRAME_RECEIVED_RES = 5;
    private static final int COMPRESSED_RECEIVED_RES = 6;
    private static final int MULTICAST_RECEIVED_RES = 7;
    private static final int BYTES_TRANSMIT_RES = 8;
    private static final int PACKETS_TRANSMIT_RES = 9;
    private static final int ERRORS_TRANSMIT_RES = 10;
    private static final int DROP_TRANSMIT_RES = 11;
    private static final int FIFO_TRANSMIT_RES = 12;
    private static final int COLLISIONS_TRANSMIT_RES = 13;
    private static final int CARRIER_TRANSMIT_RES = 14;
    private static final int COMPRESSED_TRANSMIT_RES = 15;
    private static final int MULTICAST_TRANSMIT_RES = 16;
    private long[] bytesReceived;
    private long[] packetsReceived;
    private long[] errorsReceived;
    private long[] dropReceived;
    private long[] fifoReceived;
    private long[] frameReceived;
    private long[] compressedReceived;
    private long[] multicastReceived;
    private long[] bytesTransmit;
    private long[] packetsTransmit;
    private long[] errorsTransmit;
    private long[] dropTransmit;
    private long[] fifoTransmit;
    private long[] collisionsTransmit;
    private long[] carrierTransmit;
    private long[] compressedTransmit;
    private long[] multicastTransmit;
    private int nbOfDevices = 0;

    public NetworkProbe() throws NoResourceToProbeException {
        super("network probe");
        String[] names = this.getDeviceNames();
        this.nbOfDevices = names.length;
        this.bytesReceived = new long[this.nbOfDevices];
        this.packetsReceived = new long[this.nbOfDevices];
        this.errorsReceived = new long[this.nbOfDevices];
        this.dropReceived = new long[this.nbOfDevices];
        this.fifoReceived = new long[this.nbOfDevices];
        this.frameReceived = new long[this.nbOfDevices];
        this.compressedReceived = new long[this.nbOfDevices];
        this.multicastReceived = new long[this.nbOfDevices];
        this.bytesTransmit = new long[this.nbOfDevices];
        this.packetsTransmit = new long[this.nbOfDevices];
        this.errorsTransmit = new long[this.nbOfDevices];
        this.dropTransmit = new long[this.nbOfDevices];
        this.fifoTransmit = new long[this.nbOfDevices];
        this.collisionsTransmit = new long[this.nbOfDevices];
        this.carrierTransmit = new long[this.nbOfDevices];
        this.compressedTransmit = new long[this.nbOfDevices];
        this.multicastTransmit = new long[this.nbOfDevices];
        this.resourceNames = new String[this.nbOfDevices * 17];
        this.resourceIds = new int[this.resourceNames.length];
        for (int i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        for (int j = 0; j < this.nbOfDevices; ++j) {
            this.resourceNames[j * 17 + 0] = names[j] + " bytes received";
            this.resourceNames[j * 17 + 1] = names[j] + " packets received";
            this.resourceNames[j * 17 + 2] = names[j] + " errors received";
            this.resourceNames[j * 17 + 3] = names[j] + " drop received";
            this.resourceNames[j * 17 + 4] = names[j] + " fifo received";
            this.resourceNames[j * 17 + 5] = names[j] + " frame received";
            this.resourceNames[j * 17 + 6] = names[j] + " compressed received";
            this.resourceNames[j * 17 + 7] = names[j] + " multicast received";
            this.resourceNames[j * 17 + 8] = names[j] + " bytes transmit";
            this.resourceNames[j * 17 + 9] = names[j] + " packets transmit";
            this.resourceNames[j * 17 + 10] = names[j] + " errors transmit";
            this.resourceNames[j * 17 + 11] = names[j] + " drop transmit";
            this.resourceNames[j * 17 + 12] = names[j] + " fifo transmit";
            this.resourceNames[j * 17 + 13] = names[j] + " collisions";
            this.resourceNames[j * 17 + 14] = names[j] + " carrier";
            this.resourceNames[j * 17 + 15] = names[j] + " compressed transmit";
            this.resourceNames[j * 17 + 16] = names[j] + " multicast transmit";
        }
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getNetworkUsage();
        long[] result = new long[resourceIds.length];
        block19: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 17 * this.nbOfDevices) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int net = resourceIds[i] / 17;
            switch (resourceIds[i] % 17) {
                case 0: {
                    result[i] = this.bytesReceived[net];
                    continue block19;
                }
                case 1: {
                    result[i] = this.packetsReceived[net];
                    continue block19;
                }
                case 2: {
                    result[i] = this.errorsReceived[net];
                    continue block19;
                }
                case 3: {
                    result[i] = this.dropReceived[net];
                    continue block19;
                }
                case 4: {
                    result[i] = this.fifoReceived[net];
                    continue block19;
                }
                case 5: {
                    result[i] = this.frameReceived[net];
                    continue block19;
                }
                case 6: {
                    result[i] = this.compressedReceived[net];
                    continue block19;
                }
                case 7: {
                    result[i] = this.multicastReceived[net];
                    continue block19;
                }
                case 8: {
                    result[i] = this.bytesTransmit[net];
                    continue block19;
                }
                case 9: {
                    result[i] = this.packetsTransmit[net];
                    continue block19;
                }
                case 10: {
                    result[i] = this.errorsTransmit[net];
                    continue block19;
                }
                case 11: {
                    result[i] = this.dropTransmit[net];
                    continue block19;
                }
                case 12: {
                    result[i] = this.fifoTransmit[net];
                    continue block19;
                }
                case 13: {
                    result[i] = this.collisionsTransmit[net];
                    continue block19;
                }
                case 14: {
                    result[i] = this.carrierTransmit[net];
                    continue block19;
                }
                case 15: {
                    result[i] = this.compressedTransmit[net];
                    continue block19;
                }
                case 16: {
                    result[i] = this.multicastTransmit[net];
                    continue block19;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    private void getNetworkUsage() throws ProbeException {
        long[] stats = this.getNetworkStats();
        if (stats.length != this.nbOfDevices * 17) {
            throw new ProbeException("Internal error!");
        }
        for (int net = 0; net < this.nbOfDevices; ++net) {
            this.bytesReceived[net] = stats[net * 17 + 0];
            this.packetsReceived[net] = stats[net * 17 + 1];
            this.errorsReceived[net] = stats[net * 17 + 2];
            this.dropReceived[net] = stats[net * 17 + 3];
            this.fifoReceived[net] = stats[net * 17 + 4];
            this.frameReceived[net] = stats[net * 17 + 5];
            this.compressedReceived[net] = stats[net * 17 + 6];
            this.multicastReceived[net] = stats[net * 17 + 7];
            this.bytesTransmit[net] = stats[net * 17 + 8];
            this.packetsTransmit[net] = stats[net * 17 + 9];
            this.errorsTransmit[net] = stats[net * 17 + 10];
            this.dropTransmit[net] = stats[net * 17 + 11];
            this.fifoTransmit[net] = stats[net * 17 + 12];
            this.collisionsTransmit[net] = stats[net * 17 + 13];
            this.carrierTransmit[net] = stats[net * 17 + 14];
            this.compressedTransmit[net] = stats[net * 17 + 15];
            this.multicastTransmit[net] = stats[net * 17 + 16];
        }
    }

    public native String[] getDeviceNames() throws NoResourceToProbeException;

    public native long[] getNetworkStats() throws ProbeException;

    static {
        System.loadLibrary("LeWYS");
    }
}

