/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.manager;

import java.util.HashMap;
import java.util.Hashtable;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.adl.ReconfigurationFactory;
import org.objectweb.dream.util.Error;
import org.objectweb.dream.util.Util;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.ProbeInfo;
import org.objectweb.lewys.probe.jmx.cjdbc.CjdbcProbe;
import org.objectweb.lewys.probe.linux.CpuProbe;
import org.objectweb.lewys.probe.linux.DiskProbe;
import org.objectweb.lewys.probe.linux.KernelProbe;
import org.objectweb.lewys.probe.linux.MemoryProbe;
import org.objectweb.lewys.probe.linux.NetworkProbe;
import org.objectweb.lewys.probe.manager.ProbeFactory;
import org.objectweb.lewys.probe.manager.ProbeRepository;
import org.objectweb.util.monolog.api.BasicLevel;

public class ProbeFactoryImpl
extends AbstractComponent
implements ProbeFactory,
ProbeRepository {
    protected Component composite;
    protected Hashtable repository;

    public void create(String probeName) throws ProbeException {
        HashMap<String, String> ctx = new HashMap<String, String>();
        String probeClassName = null;
        if (probeName.equals("cpu")) {
            probeClassName = "org.objectweb.lewys.probe.windows.CpuProbe";
        } else if (probeName.equals("disk")) {
            probeClassName = "org.objectweb.lewys.probe.windows.DiskProbe";
        } else if (probeName.equals("kernel")) {
            probeClassName = "org.objectweb.lewys.probe.windows.KernelProbe";
        } else if (probeName.equals("memory")) {
            probeClassName = "org.objectweb.lewys.probe.windows.MemoryProbe";
        } else if (probeName.equals("network")) {
            probeClassName = "org.objectweb.lewys.probe.windows.NetworkProbe";
        } else if (probeName.equals("cjdbc controller")) {
            probeClassName = "org.objectweb.lewys.probe.jmx.cjdbc.ControllerProbe";
        } else if (probeName.equals("cjdbc virtual database")) {
            probeClassName = "org.objectweb.lewys.probe.jmx.cjdbc.VirtualDatabaseProbe";
        } else if (probeName.equals("cjdbc")) {
            probeClassName = "org.objectweb.lewys.probe.jmx.cjdbc.CjdbcProbe";
        }
        try {
            ctx.put("probeClassName", probeClassName);
            ctx.put("probeName", probeName);
            ctx.put("timeOut", "5");
            ReconfigurationFactory.getReconfiguration().addComponents(this.composite, "org.objectweb.lewys.probe.manager.AddCachedProbe", ctx);
            try {
                Fractal.getLifeCycleController(Util.getComponentByName(Fractal.getContentController(this.composite), probeName)).startFc();
            }
            catch (Exception e) {
                Error.bug(this.logger, e);
            }
        }
        catch (ADLException e) {
            this.logger.log(BasicLevel.ERROR, (Object)("Unable to create the probe: " + probeName), (Throwable)e);
            throw new ProbeException("Unable to create the probe: " + probeName, e);
        }
    }

    public String getProbeNames() throws ProbeException {
        return "cpu network disk memory kernel";
    }

    public ProbeInfo getProbeInfo(String probeName) throws ProbeException {
        AbstractProbe probeInfo = null;
        try {
            if (probeName.equals("cpu")) {
                probeInfo = new CpuProbe();
            } else if (probeName.equals("disk")) {
                probeInfo = new DiskProbe();
            } else if (probeName.equals("kernel")) {
                probeInfo = new KernelProbe();
            } else if (probeName.equals("memory")) {
                probeInfo = new MemoryProbe();
            } else if (probeName.equals("network")) {
                probeInfo = new NetworkProbe();
            } else if (probeName.equals("cjdbc")) {
                probeInfo = new CjdbcProbe();
            }
        }
        catch (Exception e) {
            System.out.println("Unable to find Probe information" + e);
        }
        return probeInfo;
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("monitoring-pump-c")) {
            this.composite = (Component)serverItf;
        }
    }

    public String[] listFc() {
        return new String[]{"monitoring-pump-c"};
    }
}

