/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.pump;

import java.util.Hashtable;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.util.Error;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.lewys.pump.OutputManager;

public class OutputManagerImpl
extends AbstractComponent
implements OutputManager {
    private Component monitoringPumpC;
    private BindingController monitoringPumpThreadBC;
    private Hashtable outputs = new Hashtable();
    private int outputNumber = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String register(String outputName, Push output) {
        String registeredName;
        if (outputName == null) {
            registeredName = "default_" + this.outputNumber;
            ++this.outputNumber;
        } else {
            registeredName = outputName;
        }
        Hashtable hashtable = this.outputs;
        synchronized (hashtable) {
            if (this.outputs.containsKey(registeredName)) {
                if (this.outputs.get(registeredName) == output) {
                    return registeredName;
                }
                return null;
            }
            try {
                Fractal.getContentController(this.monitoringPumpC).addFcSubComponent(((Interface)((Object)output)).getFcItfOwner());
                this.monitoringPumpThreadBC.bindFc("out-push-" + registeredName, output);
                this.outputs.put(registeredName, output);
                return registeredName;
            }
            catch (Exception e) {
                Error.bug(this.logger, e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(String outputName) {
        Hashtable hashtable = this.outputs;
        synchronized (hashtable) {
            Object output = this.outputs.remove(outputName);
            if (output != null) {
                try {
                    this.monitoringPumpThreadBC.unbindFc("out-push-" + outputName);
                    Fractal.getContentController(this.monitoringPumpC).removeFcSubComponent(((Interface)output).getFcItfOwner());
                    return true;
                }
                catch (Exception e) {
                    Error.bug(this.logger, e);
                    return false;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String outputName) {
        Hashtable hashtable = this.outputs;
        synchronized (hashtable) {
            if (this.outputs.containsKey(outputName)) {
                return "out-push-" + outputName;
            }
            return null;
        }
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("monitoring-pump-c")) {
            this.monitoringPumpC = (Component)serverItf;
        } else if (clientItfName.equals("monitoring-pump-thread-bc")) {
            this.monitoringPumpThreadBC = (BindingController)serverItf;
        }
    }

    public String[] listFc() {
        return new String[]{"monitoring-pump-c", "monitoring-pump-thread-bc"};
    }
}

