/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.ratecontrol;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.util.EmptyStringArray;
import org.objectweb.lewys.filtering.SignalPoint;
import org.objectweb.lewys.message.MonitoringValueChunk;
import org.objectweb.lewys.ratecontrol.RateTimer;
import org.objectweb.lewys.ratecontrol.WindowPoint;
import org.objectweb.lewys.ratecontrol.WindowTimer;

public class RateController
extends AbstractComponent
implements Push {
    protected long windowSize;
    protected ArrayList slidingWindow = new ArrayList();
    protected long stabilityPeriod;
    protected double inputRate;
    protected double outputRate;
    protected double precisionWidth;
    protected RateTimer rateTimer;
    protected WindowTimer windowTimer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(SignalPoint spoint) {
        double newOutputRate;
        Date now = new Date();
        WindowPoint point = new WindowPoint(spoint, now.getTime());
        ArrayList arrayList = this.slidingWindow;
        synchronized (arrayList) {
            this.slidingWindow.add(point);
            if (this.slidingWindow.size() == 1) {
                this.windowTimer = new WindowTimer(this);
                this.windowTimer.start();
            }
            newOutputRate = (double)this.slidingWindow.size() / (double)this.windowSize;
        }
        if (this.outputRate < this.inputRate + this.precisionWidth && newOutputRate > this.inputRate + this.precisionWidth) {
            this.rateTimer = new RateTimer(this, this.stabilityPeriod);
            this.rateTimer.start();
        } else if (this.outputRate < this.inputRate - this.precisionWidth && newOutputRate > this.inputRate - this.precisionWidth) {
            this.rateTimer.interrupt();
        }
        this.outputRate = newOutputRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePoint() {
        double newOutputRate;
        ArrayList arrayList = this.slidingWindow;
        synchronized (arrayList) {
            this.slidingWindow.remove(0);
            newOutputRate = (double)this.slidingWindow.size() / (double)this.windowSize;
        }
        if (this.outputRate > this.inputRate - this.precisionWidth && newOutputRate < this.inputRate - this.precisionWidth) {
            this.rateTimer = new RateTimer(this, this.stabilityPeriod);
            this.rateTimer.start();
        } else if (this.outputRate > this.inputRate + this.precisionWidth && newOutputRate < this.inputRate + this.precisionWidth) {
            this.rateTimer.interrupt();
        }
        this.outputRate = newOutputRate;
    }

    public void changeInputRate() {
    }

    public void push(Message message, Map context) throws PushException {
        MonitoringValueChunk value = (MonitoringValueChunk)message.getChunk("monitoring-value-chunk");
        String senderName = "127.0.0.1";
        String probeName = value.getProbeName();
        Date timestamp = new Date(value.getTimestamp());
        int[] resource_ids = value.getResourceIds();
        long[] values = value.getValues();
        for (int i = 0; i < resource_ids.length; ++i) {
        }
    }

    public String[] listFc() {
        return EmptyStringArray.EMPTY_STRING_ARRAY;
    }
}

