/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.ratecontrol;

import java.util.ArrayList;
import java.util.Date;
import org.objectweb.lewys.ratecontrol.RateController;
import org.objectweb.lewys.ratecontrol.WindowPoint;

public class WindowTimer
extends Thread {
    private RateController father;
    private long windowSize;

    public WindowTimer(RateController father) {
        super("WindowTimer");
        this.father = father;
        this.windowSize = father.windowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            long timeInMs;
            ArrayList arrayList = this.father.slidingWindow;
            synchronized (arrayList) {
                if (this.father.slidingWindow.size() == 0) {
                    return;
                }
                WindowPoint point = (WindowPoint)this.father.slidingWindow.get(0);
                Date now = new Date();
                timeInMs = point.getArrivalTime() + this.windowSize - now.getTime();
            }
            try {
                Thread.sleep(timeInMs);
            }
            catch (InterruptedException e) {
                System.out.println("Window Timer thread interrupted");
                break;
            }
            arrayList = this.father.slidingWindow;
            synchronized (arrayList) {
                this.father.removePoint();
            }
        }
    }
}

