/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository.util;

import java.io.FileWriter;
import java.io.IOException;

public class TransferScriptGenerator {
    public static final String SCRIPT_FILE_NAME = "transfer.sql";
    private FileWriter scriptFile;
    private String[] probeTypes;
    private String[][] resourceTypes;
    private String[] postfixes;
    private int[] nResourceCopies;
    private int[] nResourceTypes;
    private int[] firstResourceTypes;

    public TransferScriptGenerator() {
        try {
            int i;
            this.probeTypes = new String[]{"cpu", "disk", "kernel", "memory", "network"};
            this.postfixes = new String[]{"", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
            this.resourceTypes = new String[][]{{"user", "nice", "kernel", "idle"}, {"reads_issued", "reads_merged", "reads_sectors", "reads_time_ms", "writes_issued", "writes_merged", "writes_sectors", "writes_time_ms", "io_progress", "io_ms", "average_io_ms"}, {"interrupts", "context_switches", "processes"}, {"total_memory", "used_memory", "free_memory", "shared", "buffers", "cached", "total_swap", "used_swap", "free_swap", "pages_in", "pages_out", "swap_in", "swap_out"}, {"bytes_received", "packets_received", "errors_received", "drop_received", "fifo_received", "frame_received", "compressed_received", "multicast", "bytes_transmit", "packets_transmit", "errors_transmit", "drop_transmit", "fifo_transmit", "collisions", "carrier", "compressed_transmit"}};
            this.nResourceCopies = new int[]{5, 12, 1, 1, 5};
            this.nResourceTypes = new int[this.probeTypes.length];
            for (i = 0; i < this.nResourceTypes.length; ++i) {
                this.nResourceTypes[i] = this.resourceTypes[i].length;
            }
            this.firstResourceTypes = new int[this.probeTypes.length];
            this.firstResourceTypes[0] = 1;
            for (i = 1; i < this.firstResourceTypes.length; ++i) {
                this.firstResourceTypes[i] = this.firstResourceTypes[i - 1] + this.nResourceTypes[i - 1] * this.nResourceCopies[i - 1];
            }
            this.scriptFile = new FileWriter(SCRIPT_FILE_NAME);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error while creating transfer script file 'transfer.sql'");
        }
    }

    public void generate() {
        String sql = null;
        try {
            this.scriptFile.write("connect lewys;\n\n\n");
            for (int i = 0; i < this.probeTypes.length; ++i) {
                for (int j = 0; j < this.nResourceCopies[i]; ++j) {
                    for (int k = 0; k < this.nResourceTypes[i]; ++k) {
                        sql = "insert into measurements1(probe_resource,value,timestmp,precision_width,sampling_freq,filter_type) (select pr.id,r." + this.resourceTypes[i][k] + this.postfixes[j] + ",r.timestmp,0,1000,0 " + "from pumps pu, probes pb, probe_resources pr, into_lewys." + this.probeTypes[i] + " r " + "where pu.node=r.node and pb.pump=pu.id and pb.probe_type=" + (i + 1) + " " + "and pr.probe=pb.id and pr.resource_type=" + (this.firstResourceTypes[i] + j * this.nResourceTypes[i] + k) + ");";
                        this.scriptFile.write(sql);
                        this.scriptFile.write("\n");
                    }
                    this.scriptFile.write("\n");
                }
                this.scriptFile.write("\n");
            }
            this.scriptFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error while writing to transfer script file 'transfer.sql'");
        }
    }

    public static void main(String[] args) {
        try {
            TransferScriptGenerator generator = new TransferScriptGenerator();
            generator.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

