/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository.util;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.objectweb.lewys.common.exceptions.RepositoryException;
import org.objectweb.lewys.repository.MonitoringRepositoryImpl;

public class UtilizationCalculator {
    private MonitoringRepositoryImpl repository = new MonitoringRepositoryImpl();
    private Connection conn = this.repository.getConnection();

    public void calculateUtilization() throws RepositoryException {
        int i;
        long[] oldTimestamps = new long[10];
        double[] oldValues = new double[10];
        ResultSet rs = null;
        PreparedStatement selectStmt = null;
        Statement insertStmt = null;
        Statement updateStmt = null;
        for (i = 0; i < oldTimestamps.length; ++i) {
            oldTimestamps[i] = -1L;
        }
        for (i = 0; i < oldValues.length; ++i) {
            oldValues[i] = -1.0;
        }
        try {
            selectStmt = this.conn.prepareStatement("SELECT probe_resource,precision_width,sampling_freq,filter_type,value,timestmp FROM measurements1 WHERE probe_resource=52");
            rs = selectStmt.executeQuery();
            while (rs.next()) {
                int probe_resource = rs.getInt("probe_resource");
                double precision_width = rs.getDouble("precision_width");
                long sampling_freq = rs.getLong("sampling_freq");
                int filter_type = rs.getInt("filter_type");
                double value = rs.getDouble("value");
                long timestamp = rs.getLong("timestmp");
                if (oldTimestamps[filter_type] < 0L) {
                    oldTimestamps[filter_type] = timestamp;
                    oldValues[filter_type] = value;
                    continue;
                }
                if (timestamp == oldTimestamps[filter_type]) continue;
                long deltaTime = timestamp - oldTimestamps[filter_type];
                double totalJiffies = 100.0 * ((double)deltaTime / 1000.0);
                double usedJiffies = value - oldValues[filter_type];
                double util = (totalJiffies - usedJiffies) / totalJiffies * 100.0;
                oldTimestamps[filter_type] = timestamp;
                oldValues[filter_type] = value;
                insertStmt = this.conn.prepareStatement("INSERT INTO measurements1 (probe_resource,precision_width,sampling_freq,filter_type,value,timestmp) values(?,?,?,?,?,?)");
                insertStmt.setInt(1, probe_resource + 10000);
                insertStmt.setDouble(2, precision_width * 2.0);
                insertStmt.setLong(3, sampling_freq);
                insertStmt.setInt(4, filter_type);
                insertStmt.setDouble(5, util);
                insertStmt.setLong(6, timestamp);
                insertStmt.executeUpdate();
                insertStmt.close();
                insertStmt = null;
            }
            selectStmt.close();
            selectStmt = null;
            this.repository.getClient().shutDown();
        }
        catch (SQLException e) {
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (insertStmt != null) {
                    insertStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new RepositoryException("Error while accessing database: " + e);
        }
    }

    public static void main(String[] args) {
        try {
            UtilizationCalculator calculator = new UtilizationCalculator();
            calculator.calculateUtilization();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

