/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.objectweb.util.monolog.TestSuite;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.TopicalLogger;

public class TestHelper
extends TestCase {
    public static final String[] SETTER_METHODS = new String[]{"setLoggerFactoryClassName"};
    public LoggerFactory lf = null;
    public HandlerFactory hf = null;
    public LevelFactory lef = null;
    protected String fileName = null;
    static boolean debug = Boolean.valueOf(System.getProperty("monolog.test.debug"));

    public TestHelper() {
        super("");
    }

    public void setLoggerFactoryClassName(String lfcn) {
        try {
            this.lf = (LoggerFactory)Class.forName(lfcn).newInstance();
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("The specified class is not a Logger factory: " + lfcn);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Logger factory class is not availlable: " + lfcn);
        }
        if (this.lf instanceof HandlerFactory) {
            this.hf = (HandlerFactory)((Object)this.lf);
        }
        if (this.lf instanceof LevelFactory) {
            this.lef = (LevelFactory)((Object)this.lf);
        }
    }

    public void setOutputFile(String filename) {
        this.fileName = filename;
    }

    public static void run(Class c, String[] methods, String[] params, String lfcn, String fn) {
        try {
            TestRunner.run((Test)TestHelper.getTestSuite(c, methods, params, lfcn, fn));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run(Class c, String[] methods, String[] params, String lfcn) {
        try {
            TestRunner.run((Test)TestHelper.getTestSuite(c, methods, params, lfcn));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TestSuite getTestSuite(Class c, String[] methods, String[] params, String lfcn, String fn) {
        Object[] myparams = new Object[params.length + 2];
        myparams[0] = lfcn;
        myparams[1] = fn;
        for (int i = 0; i < params.length; ++i) {
            myparams[i + 2] = params[i];
        }
        String[] mymethods = new String[methods.length + 2];
        mymethods[0] = "setLoggerFactoryClassName";
        mymethods[1] = "setOutputFile";
        for (int i = 0; i < methods.length; ++i) {
            mymethods[i + 2] = methods[i];
        }
        try {
            return new TestSuite(c, mymethods, myparams);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TestSuite getTestSuite(Class c, String[] methods, String[] params, String lfcn) {
        Object[] myparams = new Object[params.length + 1];
        myparams[0] = lfcn;
        for (int i = 0; i < params.length; ++i) {
            myparams[i + 1] = params[i];
        }
        String[] mymethods = new String[methods.length + 1];
        mymethods[0] = "setLoggerFactoryClassName";
        for (int i = 0; i < methods.length; ++i) {
            mymethods[i + 1] = methods[i];
        }
        try {
            return new TestSuite(c, mymethods, myparams);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length <= 1) {
            System.out.println("Invalid argument");
            System.exit(1);
        }
        try {
            File f = new File(args[0]);
            f.delete();
            f.createNewFile();
            PrintStream ps = new PrintStream(new FileOutputStream(f));
            String[] required = new String[args.length - 1];
            for (int i = 0; i < required.length; ++i) {
                required[i] = args[i + 1];
                ps.println(required[i]);
            }
            ps.flush();
            ps.close();
            TestHelper to = new TestHelper();
            to.setOutputFile(args[0]);
            to.assertInFileEquals("my message", required);
            f.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
            TestHelper.fail((String)e.getMessage());
        }
    }

    public void assertInFileEquals(String message, String required) {
        String[] r = new String[]{required};
        this.assertInFileEquals(message, this.fileName, r);
    }

    public void assertInFileEquals(String message, String filename, String required) {
        String[] r = new String[]{required};
        this.assertInFileEquals(message, filename, r);
    }

    public void assertInFileEquals(String message, String[] required) {
        String[] text = this.getFirstLines(this.fileName, required.length);
        for (int i = 0; i < required.length; ++i) {
            this.debug("found : text[" + i + "]=" + text[i] + " text[i].length = " + text[i].length());
            this.debug("required : required[" + i + "]=" + required[i] + " required[i].length = " + required[i].length());
            TestHelper.assertEquals((String)(message + " " + i), (Object)required[i], (Object)text[i]);
        }
    }

    public void assertInFileEquals(String message, String filename, String[] required) {
        String[] text = this.getFirstLines(filename, required.length);
        for (int i = 0; i < required.length; ++i) {
            this.debug("found : text[" + i + "]=" + text[i]);
            this.debug("required : required[" + i + "]=" + required[i]);
            TestHelper.assertEquals((String)(message + " " + i), (Object)required[i], (Object)text[i]);
        }
    }

    public String[] getLastLines(int linenumber) {
        return this.getLastLines(this.fileName, linenumber);
    }

    public String[] getFirstLines(int linenumber) {
        return this.getFirstLines(this.fileName, linenumber);
    }

    public String[] getFirstLines(String filename, int linenumber) {
        if (filename == null || linenumber == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>(linenumber);
        try {
            FileReader fr = new FileReader(filename);
            LineNumberReader lnr = new LineNumberReader(fr);
            String str = lnr.readLine();
            for (int i = 0; i < linenumber && str != null; ++i) {
                v.addElement(str);
                str = lnr.readLine();
            }
            int size = v.size();
            String[] res = new String[size];
            for (int j = 0; j < size; ++j) {
                res[j] = (String)v.elementAt(j);
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getLastLines(String filename, int linenumber) {
        if (filename == null || linenumber == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>(linenumber);
        try {
            FileReader fr = new FileReader(filename);
            LineNumberReader lnr = new LineNumberReader(fr);
            String str = lnr.readLine();
            int i = 0;
            while (str != null) {
                v.addElement(str);
                str = lnr.readLine();
                ++i;
            }
            int size = v.size();
            String[] res = new String[size];
            for (int j = 0; j < size; ++j) {
                res[j] = (String)v.elementAt(size - 1 - j);
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void quietRootLogger() {
        TopicalLogger l = (TopicalLogger)this.lf.getLogger("root");
        Handler[] hcs = l.getHandler();
        Handler hc = this.hf.createHandler("handlerOfroot", (byte)1);
        hc.setAttribute("output", "rootLogger.log");
        hc.setAttribute("pattern", "%m%n");
        try {
            l.addHandler(hc);
            for (int i = 0; i < hcs.length; ++i) {
                l.removeHandler(hcs[i]);
            }
        }
        catch (Exception e) {
            TestHelper.fail((String)("error" + e.getMessage()));
        }
        l = null;
    }

    protected void debug(String m) {
        if (debug) {
            System.out.println(m);
        }
    }

    private int next(int i, int max) {
        return i + 1 == max ? 0 : i + 1;
    }
}

