/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;

public abstract class AbstractFactory
implements MonologFactory {
    public static boolean debug = false;
    protected String resourceBundleName = null;
    protected Map nameToLevel = null;
    protected Map intToNames = new HashMap();
    protected Map handlers = null;

    public static void debug(String m) {
        if (debug) {
            System.out.println(m);
        }
    }

    public AbstractFactory() {
        this.nameToLevel = new HashMap();
        this.handlers = new HashMap();
        this.defineLevel(BasicLevel.LEVEL_INHERIT);
        this.defineLevel(BasicLevel.LEVEL_DEBUG);
        this.defineLevel(BasicLevel.LEVEL_INFO);
        this.defineLevel(BasicLevel.LEVEL_WARN);
        this.defineLevel(BasicLevel.LEVEL_ERROR);
        this.defineLevel(BasicLevel.LEVEL_FATAL);
    }

    private Level defineLevel(Level l) {
        String name = l.getName();
        int value = l.getIntValue();
        Level res = (Level)this.nameToLevel.get(name);
        if (res != null) {
            return res.getIntValue() == value ? res : null;
        }
        res = l;
        this.nameToLevel.put(name, res);
        Integer i = new Integer(value);
        Object temp = this.intToNames.get(i);
        if (temp != null) {
            ArrayList al;
            if (temp instanceof String) {
                if (!((String)temp).equalsIgnoreCase(name)) {
                    ArrayList<Object> al2 = new ArrayList<Object>(5);
                    al2.add(temp);
                    al2.add(name);
                    this.intToNames.put(i, al2);
                }
            } else if (temp instanceof ArrayList && !(al = (ArrayList)temp).contains(name)) {
                al.add(name);
            }
        } else {
            this.intToNames.put(i, name);
        }
        return res;
    }

    public abstract void configure(Properties var1) throws Exception;

    public abstract Logger getLogger(String var1);

    public abstract Logger[] getLoggers();

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String rbn) {
        this.resourceBundleName = rbn;
    }

    public abstract Handler createHandler(String var1, byte var2);

    public Handler[] getHandlers() {
        return this.handlers.values().toArray(new Handler[0]);
    }

    public Handler getHandler(String hn) {
        return (Handler)this.handlers.get(hn);
    }

    public Handler removeHandler(String hn) {
        return (Handler)this.handlers.remove(hn);
    }

    public Level defineLevel(String name, int value) {
        return this.defineLevel(new LevelImpl(name, value));
    }

    public Level defineLevel(String name, String value) {
        return this.defineLevel(new LevelImpl(name, value, this));
    }

    public Level getLevel(String name) {
        return (Level)this.nameToLevel.get(name);
    }

    public Level getLevel(int value) {
        Object temp = this.intToNames.get(new Integer(value));
        if (temp == null) {
            return null;
        }
        if (temp instanceof String) {
            return this.getLevel((String)temp);
        }
        if (temp instanceof ArrayList) {
            return this.getLevel((String)((ArrayList)temp).get(0));
        }
        return null;
    }

    public Level[] getLevels() {
        return this.nameToLevel.values().toArray(new Level[0]);
    }

    public void removeLevel(String name) {
        Level removed = (Level)this.nameToLevel.remove(name);
        if (removed != null) {
            Integer i = new Integer(removed.getIntValue());
            Object temp = this.intToNames.get(i);
            if (temp instanceof String) {
                this.intToNames.remove(i);
            } else if (temp instanceof ArrayList) {
                ((ArrayList)temp).remove(name);
            }
        }
    }

    static {
        debug = new Boolean(System.getProperty("monolog.debug"));
    }
}

