/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.jasmine.monitoring.mbeancmd.graph.GraphDisplay;
import org.ow2.jasmine.monitoring.mbeancmd.graph.SerieListener;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.GraphConfig;

public class Graph
implements SerieListener {
    private GraphConfig conf = null;
    private GraphDisplay display = null;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public Graph(GraphConfig conf) {
        this.conf = conf;
        this.display = new GraphDisplay(conf);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("New graph: " + conf.getId());
        }
    }

    public void update(String serie, long x, long y) {
        this.display.update(serie, x, (double)y);
    }

    public void update(String serie, long t, double y) {
        this.display.update(serie, t, y);
    }

    public void update(String serie, double x, long y) {
        this.display.update(serie, new Double(x).longValue(), (double)y);
    }

    public void update(String serie, double x, double y) {
        this.display.update(serie, new Double(x).longValue(), y);
    }

    public GraphConfig getConfig() {
        return this.conf;
    }
}

