/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.MuleObjectHelper;

public class TransformerReference {
    protected static final Log logger = LogFactory.getLog(TransformerReference.class);
    private final String propertyName;
    private final String transformerName;
    private final Object object;

    public TransformerReference(String propertyName, String transformerName, Object object) {
        this.propertyName = propertyName;
        this.transformerName = transformerName;
        this.object = object;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getTransformerName() {
        return this.transformerName;
    }

    public Object getObject() {
        return this.object;
    }

    public void resolveTransformer() throws InitialisationException {
        UMOTransformer trans = null;
        try {
            trans = MuleObjectHelper.getTransformer(this.transformerName, " ");
            if (trans == null) {
                throw new InitialisationException(CoreMessages.objectNotRegisteredWithManager("Transformer '" + this.transformerName + "'"), this.object);
            }
            logger.info("Setting transformer: " + this.transformerName + " on " + this.object.getClass().getName() + "." + this.propertyName);
            BeanUtils.setProperty(this.object, this.propertyName, trans);
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.cannotSetPropertyOnObjectWithParamType(this.propertyName, this.object.getClass(), trans.getClass()), (Object)e);
        }
    }
}

