/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.InputStream;
import javax.servlet.ServletContext;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.util.FileUtils;

public class WebappMuleXmlConfigurationBuilder
extends MuleXmlConfigurationBuilder {
    private ServletContext context;
    private String webappClasspath;

    public WebappMuleXmlConfigurationBuilder(ServletContext context, String webappClasspath) throws ConfigurationException {
        this.context = context;
        this.webappClasspath = webappClasspath;
    }

    protected InputStream loadResource(String resource) throws ConfigurationException {
        String resourcePath = FileUtils.newFile(this.webappClasspath, resource).getPath();
        this.logger.debug("Searching for resource " + resourcePath + " in Servlet Context.");
        InputStream is = this.context.getResourceAsStream(resourcePath);
        if (is == null) {
            this.logger.debug("Resource " + resourcePath + " not found in Servlet Context, loading from classpath");
            is = super.loadResource(resource);
        }
        return is;
    }
}

