/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.ResponseOutputStream;
import org.mule.impl.model.streaming.CloseCountDownInputStream;
import org.mule.impl.model.streaming.CloseCountDownOutputStream;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.AbstractReceiverResourceWorker;
import org.mule.providers.ConnectException;
import org.mule.providers.tcp.TcpConnector;
import org.mule.providers.tcp.TcpProtocol;
import org.mule.providers.tcp.i18n.TcpMessages;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.DisposeException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOStreamMessageAdapter;

public class TcpMessageReceiver
extends AbstractMessageReceiver
implements Work {
    private ServerSocket serverSocket = null;

    public TcpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    protected void doConnect() throws ConnectException {
        this.disposing.set(false);
        URI uri = this.endpoint.getEndpointURI().getUri();
        try {
            this.serverSocket = ((TcpConnector)this.connector).getServerSocket(uri);
        }
        catch (Exception e) {
            throw new ConnectException(TcpMessages.failedToBindToUri(uri), e, this);
        }
        try {
            this.getWorkManager().scheduleWork(this, Long.MAX_VALUE, null, this.connector);
        }
        catch (WorkException e) {
            throw new ConnectException(CoreMessages.failedToScheduleWork(), e, this);
        }
    }

    protected void doDisconnect() throws ConnectException {
        this.disposing.set(true);
        try {
            if (this.serverSocket != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Closing: " + this.serverSocket);
                }
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to close server socket: " + e.getMessage(), e);
        }
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void run() {
        while (!this.disposing.get()) {
            Socket socket;
            block10: {
                if (!this.connector.isStarted() || this.disposing.get()) continue;
                socket = null;
                try {
                    socket = this.serverSocket.accept();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Accepted: " + this.serverSocket);
                    }
                }
                catch (InterruptedIOException iie) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Interupted IO doing serverSocket.accept: " + iie.getMessage());
                    }
                }
                catch (Exception e) {
                    if (this.connector.isDisposed() || this.disposing.get()) break block10;
                    this.logger.warn("Accept failed on socket: " + e, e);
                    this.handleException(new ConnectException(e, (Object)this));
                }
            }
            if (socket == null) continue;
            try {
                Work work = this.createWork(socket);
                try {
                    this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, this.connector);
                }
                catch (WorkException e) {
                    this.logger.error("Tcp Server receiver Work was not processed: " + e.getMessage(), e);
                }
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }
    }

    public void release() {
    }

    protected void doDispose() {
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Closing: " + this.serverSocket);
                }
                this.serverSocket.close();
            }
            this.serverSocket = null;
        }
        catch (Exception e) {
            this.logger.error(new DisposeException(TcpMessages.failedToCloseSocket(), (Object)e));
        }
        this.logger.info("Closed Tcp port");
    }

    protected Work createWork(Socket socket) throws IOException {
        if (this.endpoint.isStreaming()) {
            return new TcpStreamWorker(socket, this);
        }
        return new TcpWorker(socket, this);
    }

    protected class TcpStreamWorker
    extends TcpWorker {
        private CountDownLatch latch;

        public TcpStreamWorker(Socket socket, TcpMessageReceiver receiver) throws IOException {
            super(socket, receiver);
        }

        protected Object getNextMessage(Object resource) throws Exception {
            if (this.endpoint.isSynchronous()) {
                this.latch = new CountDownLatch(2);
                this.dataOut = new CloseCountDownOutputStream(this.dataOut, this.latch);
            } else {
                this.latch = new CountDownLatch(2);
            }
            this.dataIn = new CloseCountDownInputStream(this.dataIn, this.latch);
            UMOStreamMessageAdapter adapter = TcpMessageReceiver.this.connector.getStreamMessageAdapter(this.dataIn, this.dataOut);
            return adapter;
        }

        protected void handleResults(List messages) throws Exception {
            this.latch.await();
        }
    }

    protected class TcpWorker
    extends AbstractReceiverResourceWorker
    implements Disposable {
        protected Socket socket;
        protected InputStream dataIn;
        protected OutputStream dataOut;
        protected AtomicBoolean closed;
        protected TcpProtocol protocol;

        public TcpWorker(Object resource, AbstractMessageReceiver receiver) throws IOException {
            super(resource, receiver, (OutputStream)new ResponseOutputStream((Socket)resource));
            this.socket = null;
            this.closed = new AtomicBoolean(false);
            this.socket = (Socket)resource;
            TcpConnector tcpConnector = (TcpConnector)TcpMessageReceiver.this.connector;
            this.protocol = tcpConnector.getTcpProtocol();
            try {
                if (tcpConnector.getReceiveBufferSize() != -1 && this.socket.getReceiveBufferSize() != tcpConnector.getReceiveBufferSize()) {
                    this.socket.setReceiveBufferSize(tcpConnector.getReceiveBufferSize());
                }
                if (tcpConnector.getSendBufferSize() != -1 && this.socket.getSendBufferSize() != tcpConnector.getSendBufferSize()) {
                    this.socket.setSendBufferSize(tcpConnector.getSendBufferSize());
                }
                if (tcpConnector.getReceiveTimeout() != -1 && this.socket.getSoTimeout() != tcpConnector.getReceiveTimeout()) {
                    this.socket.setSoTimeout(tcpConnector.getReceiveTimeout());
                }
                this.socket.setTcpNoDelay(tcpConnector.isSendTcpNoDelay());
                this.socket.setKeepAlive(tcpConnector.isKeepAlive());
                this.dataIn = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.dataOut = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            }
            catch (IOException e) {
                TcpMessageReceiver.this.logger.error("Failed to set Socket properties: " + e.getMessage(), e);
            }
        }

        public void dispose() {
            this.release();
        }

        public void release() {
            this.closed.set(true);
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    if (TcpMessageReceiver.this.logger.isDebugEnabled()) {
                        SocketAddress socketAddress = this.socket.getLocalSocketAddress();
                        if (socketAddress == null) {
                            TcpMessageReceiver.this.logger.debug("Listener has already been closed by other process.");
                        } else {
                            TcpMessageReceiver.this.logger.debug("Closing listener: " + socketAddress);
                        }
                    }
                    this.socket.close();
                }
            }
            catch (IOException e) {
                TcpMessageReceiver.this.logger.warn("Socket close failed with: " + e);
            }
        }

        protected void bindTransaction(UMOTransaction tx) throws TransactionException {
        }

        protected Object getNextMessage(Object resource) throws Exception {
            while (!this.socket.isClosed() && !TcpMessageReceiver.this.disposing.get()) {
                try {
                    Object readMsg = this.protocol.read(this.dataIn);
                    if (readMsg == null) {
                        return null;
                    }
                    return readMsg;
                }
                catch (SocketTimeoutException e) {
                    if (this.socket.getKeepAlive()) continue;
                    return null;
                }
            }
            return null;
        }

        protected void handleResults(List messages) throws Exception {
            Iterator iterator = messages.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                this.protocol.write(this.dataOut, o);
                this.dataOut.flush();
            }
        }

        protected Object processData(Object data) throws Exception {
            UMOMessageAdapter adapter = TcpMessageReceiver.this.connector.getMessageAdapter(data);
            ResponseOutputStream os = new ResponseOutputStream(this.socket);
            UMOMessage returnMessage = TcpMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage(adapter), this.endpoint.isSynchronous(), os);
            if (returnMessage != null) {
                return returnMessage;
            }
            return null;
        }
    }
}

