/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.routing.AbstractRouter;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOInboundRouter;
import org.mule.umo.transformer.TransformerException;

public class SelectiveConsumer
extends AbstractRouter
implements UMOInboundRouter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile UMOFilter filter;
    private volatile boolean transformFirst = true;

    public boolean isMatch(UMOEvent event) throws MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Attempting to route event: " + event.getId());
        }
        if (this.filter == null) {
            return true;
        }
        UMOMessage message = event.getMessage();
        if (this.transformFirst) {
            try {
                Object payload = event.getTransformedMessage();
                message = new MuleMessage(payload, message);
            }
            catch (TransformerException e) {
                throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), event.getMessage(), event.getEndpoint(), e);
            }
        }
        boolean result = this.filter.accept(message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Event " + event.getId() + (result ? " passed filter " : " did not pass filter ") + this.filter.getClass().getName());
        }
        return result;
    }

    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        if (this.isMatch(event)) {
            return new UMOEvent[]{event};
        }
        return null;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public boolean isTransformFirst() {
        return this.transformFirst;
    }

    public void setTransformFirst(boolean transformFirst) {
        this.transformFirst = transformFirst;
    }
}

