/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;

public class FilteringListMessageSplitter
extends AbstractMessageSplitter {
    private static final ThreadLocal payloadContext = new ThreadLocal();
    private static final ThreadLocal propertiesContext = new ThreadLocal();

    protected void initialise(UMOMessage message) {
        if (message.getPayload() instanceof List) {
            LinkedList payload = new LinkedList((List)message.getPayload());
            payloadContext.set(payload);
            if (this.enableCorrelation != 2) {
                int groupSize = payload.size();
                message.setCorrelationGroupSize(groupSize);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("java.util.List payload detected, setting correlation group size to " + groupSize);
                }
            }
        } else {
            throw new IllegalArgumentException("The payload for this router must be of type java.util.List");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        Iterator iterator = message.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String propertyKey = (String)iterator.next();
            props.put(propertyKey, message.getProperty(propertyKey));
        }
        propertiesContext.set(props);
    }

    protected UMOMessage getMessagePart(UMOMessage message, UMOEndpoint endpoint) {
        List payloads = (List)payloadContext.get();
        Iterator i = payloads.iterator();
        while (i.hasNext()) {
            Object payload = i.next();
            MuleMessage result = new MuleMessage(payload, (Map)propertiesContext.get());
            if (endpoint.getFilter() != null && !endpoint.getFilter().accept(result)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Endpoint filter matched. Routing message over: " + endpoint.getEndpointURI().toString());
            }
            i.remove();
            return result;
        }
        return null;
    }
}

