/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.MuleConfiguration;
import org.mule.impl.MuleDescriptor;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.TestCaseWatchdog;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.model.UMOModel;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.FileUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public abstract class AbstractMuleTestCase
extends TestCase {
    private static final boolean verbose;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean offline = System.getProperty("org.mule.offline", "false").equalsIgnoreCase("true");
    private static Map testCounters;
    private TestCaseWatchdog watchdog;

    public AbstractMuleTestCase() {
        if (testCounters == null) {
            testCounters = new HashMap();
        }
        this.addTest();
    }

    protected void addTest() {
        TestInfo info = (TestInfo)testCounters.get(((Object)((Object)this)).getClass().getName());
        if (info == null) {
            info = new TestInfo(((Object)((Object)this)).getClass().getName());
            testCounters.put(((Object)((Object)this)).getClass().getName(), info);
        }
        info.incTestCount();
    }

    protected void setDisposeManagerPerSuite(boolean val) {
        this.getTestInfo().setDisposeManagerPerSuite(val);
    }

    protected TestInfo getTestInfo() {
        TestInfo info = (TestInfo)testCounters.get(((Object)((Object)this)).getClass().getName());
        if (info == null) {
            info = new TestInfo(((Object)((Object)this)).getClass().getName());
            testCounters.put(((Object)((Object)this)).getClass().getName(), info);
        }
        return info;
    }

    private void clearAllCounters() {
        if (testCounters != null) {
            testCounters.clear();
        }
    }

    private void clearCounter() {
        if (testCounters != null) {
            testCounters.remove(((Object)((Object)this)).getClass().getName());
        }
    }

    public String getName() {
        return super.getName().substring(4).replaceAll("([A-Z])", " $1").toLowerCase() + " ";
    }

    public void run(TestResult result) {
        if (this.isDisabledInThisEnvironment()) {
            this.logger.info(((Object)((Object)this)).getClass().getName() + " disabled");
            return;
        }
        super.run(result);
    }

    protected boolean isDisabledInThisEnvironment() {
        return false;
    }

    public void runBare() throws Throwable {
        if (this.isDisabledInThisEnvironment(super.getName())) {
            this.logger.warn(((Object)((Object)this)).getClass().getName() + "." + super.getName() + " disabled in this environment");
            return;
        }
        super.runBare();
    }

    protected boolean isDisabledInThisEnvironment(String testMethodName) {
        return false;
    }

    public boolean isOffline(String method) {
        if (this.offline) {
            this.logger.warn(StringMessageUtils.getBoilerPlate("Working offline cannot run test: " + method, '=', 80));
        }
        return this.offline;
    }

    protected final void setUp() throws Exception {
        this.watchdog = new TestCaseWatchdog(30L, TimeUnit.MINUTES);
        this.watchdog.start();
        if (verbose) {
            System.out.println(StringMessageUtils.getBoilerPlate("Testing: " + this.toString(), '=', 80));
        }
        MuleManager.getConfiguration().getDefaultThreadingProfile().setDoThreading(false);
        MuleManager.getConfiguration().setServerUrl("");
        try {
            if (this.getTestInfo().getRunCount() == 0) {
                if (this.getTestInfo().isDisposeManagerPerSuite()) {
                    this.disposeManager();
                }
                this.suitePreSetUp();
            }
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
            this.doSetUp();
            if (this.getTestInfo().getRunCount() == 0) {
                this.suitePostSetUp();
            }
        }
        catch (Exception e) {
            this.getTestInfo().incRunCount();
            throw e;
        }
    }

    protected void suitePreSetUp() throws Exception {
    }

    protected void suitePostSetUp() throws Exception {
    }

    protected void suitePreTearDown() throws Exception {
    }

    protected void suitePostTearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void tearDown() throws Exception {
        try {
            if (this.getTestInfo().getRunCount() == this.getTestInfo().getTestCount()) {
                this.suitePreTearDown();
            }
            this.doTearDown();
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.getTestInfo().incRunCount();
                if (this.getTestInfo().getRunCount() != this.getTestInfo().getTestCount()) throw throwable;
                try {
                    this.suitePostTearDown();
                    throw throwable;
                }
                finally {
                    this.clearCounter();
                    this.disposeManager();
                }
            }
            finally {
                this.watchdog.cancel();
            }
        }
        try {
            this.getTestInfo().incRunCount();
            if (this.getTestInfo().getRunCount() != this.getTestInfo().getTestCount()) return;
            try {
                this.suitePostTearDown();
                return;
            }
            finally {
                this.clearCounter();
                this.disposeManager();
            }
        }
        finally {
            this.watchdog.cancel();
        }
    }

    protected void disposeManager() throws UMOException {
        if (MuleManager.isInstanciated()) {
            MuleManager.getInstance().dispose();
        }
        FileUtils.deleteTree(FileUtils.newFile(MuleManager.getConfiguration().getWorkingDirectory()));
        FileUtils.deleteTree(FileUtils.newFile("./ActiveMQ"));
        MuleManager.setConfiguration(new MuleConfiguration());
    }

    protected void doSetUp() throws Exception {
    }

    protected void doTearDown() throws Exception {
    }

    public static UMOManager getManager(boolean disableAdminAgent) throws Exception {
        return MuleTestUtils.getManager(disableAdminAgent);
    }

    public static UMOModel getDefaultModel() throws UMOException {
        return MuleTestUtils.getDefaultModel();
    }

    public static UMOEndpoint getTestEndpoint(String name, String type) throws Exception {
        return MuleTestUtils.getTestEndpoint(name, type);
    }

    public static UMOEvent getTestEvent(Object data) throws Exception {
        return MuleTestUtils.getTestEvent(data);
    }

    public static UMOEventContext getTestEventContext(Object data) throws Exception {
        return MuleTestUtils.getTestEventContext(data);
    }

    public static UMOTransformer getTestTransformer() {
        return MuleTestUtils.getTestTransformer();
    }

    public static UMOEvent getTestEvent(Object data, MuleDescriptor descriptor) throws Exception {
        return MuleTestUtils.getTestEvent(data, descriptor);
    }

    public static UMOEvent getTestEvent(Object data, UMOImmutableEndpoint endpoint) throws Exception {
        return MuleTestUtils.getTestEvent(data, endpoint);
    }

    public static UMOEvent getTestEvent(Object data, MuleDescriptor descriptor, UMOImmutableEndpoint endpoint) throws UMOException {
        return MuleTestUtils.getTestEvent(data, descriptor, endpoint);
    }

    public static UMOSession getTestSession(UMOComponent component) {
        return MuleTestUtils.getTestSession(component);
    }

    public static TestConnector getTestConnector() {
        return MuleTestUtils.getTestConnector();
    }

    public static UMOComponent getTestComponent(MuleDescriptor descriptor) {
        return MuleTestUtils.getTestComponent(descriptor);
    }

    public static MuleDescriptor getTestDescriptor(String name, String implementation) throws Exception {
        return MuleTestUtils.getTestDescriptor(name, implementation);
    }

    public static UMOManager getTestManager() throws Exception {
        return MuleTestUtils.getManager(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clearAllCounters();
        }
        finally {
            super.finalize();
        }
    }

    static {
        String muleOpts = SystemUtils.getenv("MULE_TEST_OPTS");
        if (StringUtils.isNotBlank(muleOpts)) {
            Map parsedOpts = SystemUtils.parsePropertyDefinitions(muleOpts);
            String optVerbose = (String)parsedOpts.get("mule.verbose");
            verbose = Boolean.valueOf(optVerbose);
        } else {
            verbose = true;
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
    }

    protected class TestInfo {
        private boolean disposeManagerPerSuite = false;
        private int testCount = 0;
        private int runCount = 0;
        private String name;

        public TestInfo(String name) {
            this.name = name;
        }

        public void clearCounts() {
            this.testCount = 0;
            this.runCount = 0;
        }

        public void incTestCount() {
            ++this.testCount;
        }

        public void incRunCount() {
            ++this.runCount;
        }

        public int getTestCount() {
            return this.testCount;
        }

        public int getRunCount() {
            return this.runCount;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDisposeManagerPerSuite() {
            return this.disposeManagerPerSuite;
        }

        public void setDisposeManagerPerSuite(boolean disposeManagerPerSuite) {
            this.disposeManagerPerSuite = disposeManagerPerSuite;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            return buf.append(this.name).append(", (").append(this.runCount).append(" / ").append(this.testCount).append(") tests run, disposePerSuite=").append(this.disposeManagerPerSuite).toString();
        }
    }
}

