/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.apache.commons.lang.CharUtils;
import org.mule.util.ArrayUtils;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    private static final String HEX_CHARACTERS = "0123456789abcdef";
    private static final String HEX_CHARACTERS_UC = "0123456789abcdef".toUpperCase();

    public static String[] splitAndTrim(String string, String delim) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] tokens = StringUtils.split(string, delim);
        if (tokens != null) {
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = StringUtils.trim(tokens[i]);
            }
        }
        return tokens;
    }

    public static byte[] hexStringToByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int stringLength = hex.length();
        if (stringLength % 2 != 0) {
            throw new IllegalArgumentException("Hex String must have even number of characters!");
        }
        byte[] result = new byte[stringLength / 2];
        int j = 0;
        for (int i = 0; i < result.length; ++i) {
            char hi = Character.toLowerCase(hex.charAt(j++));
            char lo = Character.toLowerCase(hex.charAt(j++));
            result[i] = (byte)(Character.digit(hi, 16) << 4 | Character.digit(lo, 16));
        }
        return result;
    }

    public static String repeat(char c, int len) {
        return StringUtils.repeat(CharUtils.toString(c), len);
    }

    public static String toHexString(byte[] bytes) {
        return StringUtils.toHexString(bytes, false);
    }

    public static String toHexString(byte[] bytes, boolean uppercase) {
        if (bytes == null) {
            return null;
        }
        int numBytes = bytes.length;
        StringBuffer str = new StringBuffer(numBytes * 2);
        String table = uppercase ? HEX_CHARACTERS_UC : HEX_CHARACTERS;
        for (int i = 0; i < numBytes; ++i) {
            str.append(table.charAt(bytes[i] >>> 4 & 0xF));
            str.append(table.charAt(bytes[i] & 0xF));
        }
        return str.toString();
    }
}

