/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SampleData {
    private long sampleTime = 0L;
    private String name = null;
    private String jmxURL = null;
    private String server = null;
    private String domain = null;
    private String objectName = null;
    private boolean status = false;
    protected static final DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static String separator = ";";
    private Map<String, Object> atts = new TreeMap<String, Object>();

    public abstract void compute(SampleData var1);

    public final String getPrintHeader() {
        String header = "time" + SampleData.getSeparator() + "date" + SampleData.getSeparator() + "sname" + SampleData.getSeparator() + "server" + SampleData.getSeparator() + "domain" + SampleData.getSeparator() + "mbean" + SampleData.getSeparator() + this.getInnerPrintHeader();
        return header;
    }

    protected abstract String getInnerPrintHeader();

    public void printData(PrintStream out) {
        Date d = new Date(this.getSampleTime());
        String result = this.getSampleTime() + SampleData.getSeparator() + simpleDateFormat.format(d) + SampleData.getSeparator() + this.getJmxURL() + SampleData.getSeparator() + this.getServer() + SampleData.getSeparator() + this.getDomain() + SampleData.getSeparator() + this.objectName + SampleData.getSeparator() + this.getInnerPrintData();
        out.println(result);
    }

    protected abstract String getInnerPrintData();

    public String getObjectName() {
        return this.objectName;
    }

    protected final void setObjectName(ObjectName on) {
        this.objectName = on.getCanonicalName();
    }

    public final long getSampleTime() {
        return this.sampleTime;
    }

    protected final void setSampleTime(long t) {
        this.sampleTime = t;
    }

    protected final void setAttribute(Attribute att) {
        this.atts.put(att.getName(), att.getValue());
    }

    protected final Object getAttribute(String name) {
        return this.atts.get(name);
    }

    protected final int getAttributeAsInt(String name) {
        return (Integer)this.atts.get(name);
    }

    protected final long getAttributeAsLong(String name) {
        return (Long)this.atts.get(name);
    }

    protected final double getAttributeAsDouble(String name) {
        return (Double)this.atts.get(name);
    }

    protected static final String getSeparator() {
        return separator;
    }

    public static final void setSeparator(String s) {
        separator = s;
    }

    public final String getName() {
        return this.name;
    }

    public final String getJmxURL() {
        return this.jmxURL;
    }

    public final String getServer() {
        return this.server;
    }

    public final String getDomain() {
        return this.domain;
    }

    protected final void setServerInfo(String name, String jmxURL, String server, String domain) {
        this.name = name;
        this.jmxURL = jmxURL;
        this.server = server;
        this.domain = domain;
    }

    protected final void setValid(boolean status) {
        this.status = status;
    }

    protected final boolean isValid() {
        return this.status;
    }

    public Map<String, ?> getValueOfAttributes() {
        throw new UnsupportedOperationException();
    }

    static {
        DecimalFormatSymbols sym = new DecimalFormatSymbols();
        sym.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(sym);
        decimalFormat.applyPattern("#.#");
    }
}

