/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.compression;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.ClassUtils;
import org.mule.util.compression.CompressionStrategy;

public final class CompressionHelper {
    private static Log logger = LogFactory.getLog(CompressionHelper.class);
    private static CompressionStrategy defaultStrategy;

    private CompressionHelper() {
    }

    public static synchronized CompressionStrategy getDefaultCompressionStrategy() {
        if (defaultStrategy == null) {
            defaultStrategy = (CompressionStrategy)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Object o = ClassUtils.loadClass("org.mule.util.compression.GZipCompression", class$org$mule$util$compression$CompressionHelper == null ? (class$org$mule$util$compression$CompressionHelper = CompressionHelper.class$("org.mule.util.compression.CompressionHelper")) : class$org$mule$util$compression$CompressionHelper).newInstance();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Found CompressionStrategy: " + o.getClass().getName());
                        }
                        return o;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to build compression strategy: " + e.getMessage());
                        return null;
                    }
                }
            });
        }
        return defaultStrategy;
    }
}

