/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCConnections
extends AbstractCommand {
    private Options options = null;
    private CommandLine commandLine = null;
    private CommandDispatcher cmdDispatcher = null;
    private String outputFilePath = null;
    private Integer duration;
    private String dataSourceName;

    public JDBCConnections() {
        this.setOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int exec(CommandDispatcher cmdDispatcher) {
        this.cmdDispatcher = cmdDispatcher;
        try {
            if (this.arguments == null) {
                this.arguments = new String[1];
                this.arguments[0] = "";
            }
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        String[] targets = JmxHelper.getJmxTargets(this.commandLine.getOptionValues("target"));
        if (targets != null && targets.length > 0) {
            PrintStream os = System.out;
            if (this.outputFilePath != null) {
                File file = new File(this.outputFilePath);
                if (file.isDirectory()) {
                    System.err.println("'" + this.outputFilePath + "' is a directory, remove it first.");
                    return 3;
                }
                try {
                    os = new PrintStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    System.err.println("Cannot open '" + this.outputFilePath + "' for write: " + e.getMessage());
                    return 3;
                }
            }
            JDBCConnections.writeHeaders(os);
            JmxAp accessPoint = null;
            try {
                ObjectName dataSourceObjectName = ObjectName.getInstance(this.dataSourceName);
                for (int i = 0; i < targets.length; ++i) {
                    String serviceUrl = JmxHelper.getJmxUrl(targets[i]);
                    accessPoint = new JmxAp(serviceUrl, this.cmdDispatcher);
                    MBeanServerConnection connection = null;
                    connection = accessPoint.getMBeanServerConnection();
                    Object[] params = new Object[]{this.duration};
                    String[] signature = new String[]{Integer.TYPE.getName()};
                    int[] ids = (int[])connection.invoke(dataSourceObjectName, "getOpenedConnections", params, signature);
                    for (int j = 0; j < ids.length; ++j) {
                        String[] signature2;
                        Object[] parameters = new Object[]{ids[j]};
                        Map details = (Map)connection.invoke(dataSourceObjectName, "getConnectionDetails", parameters, signature2 = new String[]{Integer.TYPE.getName()});
                        Long openDuration = (Long)details.get("duration");
                        if (openDuration != -1L && openDuration < this.duration.longValue() * 1000L) continue;
                        this.writeConnectionDetails(os, details);
                        if (j == ids.length - 1) continue;
                        os.println("-------------- next connection -----------------");
                    }
                }
                return 0;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                int n = 2;
                return n;
            }
            finally {
                if (accessPoint != null) {
                    accessPoint.releaseMBeanServerConnection();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
        System.err.println("Target not found.");
        return 1;
    }

    private static void writeHeaders(PrintStream stream) {
        stream.println("# ---------------------------------------------------");
        stream.println("# Generated by MBeanCmd (" + new Date() + ")");
        stream.println("# ---------------------------------------------------");
    }

    private void writeConnectionDetails(PrintStream stream, Map<String, Object> details) {
        Integer id = (Integer)details.get("id");
        stream.println("Connection ID: " + id);
        Integer openCount = (Integer)details.get("open-count");
        stream.println("Usage count: " + openCount);
        Boolean status = (Boolean)details.get("inactive");
        stream.println("Is inactive: " + status);
        long duration = (Long)details.get("duration");
        if (duration != -1L) {
            long durationDays = JDBCConnections.getNumberOfDays(duration);
            long durationHours = JDBCConnections.getNumberOfHours(duration, durationDays);
            long durationMinutes = JDBCConnections.getNumberOfMinutes(duration, durationDays, durationHours);
            long durationSeconds = JDBCConnections.getNumberOfSeconds(duration, durationDays, durationHours, durationMinutes);
            stream.format("Elapsed time since 'getConnection': %,d ms (%2$d days %3$d hours %4$d minutes %5$d seconds)%n", duration, durationDays, durationHours, durationMinutes, durationSeconds);
        } else {
            stream.println("Elapsed time since 'getConnection': unavailable");
        }
        String xid = (String)details.get("transaction-id");
        stream.println("Associated Transaction Xid: " + xid);
        long age = (Long)details.get("age");
        long ageDays = JDBCConnections.getNumberOfDays(age);
        long ageHours = JDBCConnections.getNumberOfHours(age, ageDays);
        long ageMinutes = JDBCConnections.getNumberOfMinutes(age, ageDays, ageHours);
        long ageSeconds = JDBCConnections.getNumberOfSeconds(age, ageDays, ageHours, ageMinutes);
        stream.format("Connection age (since creation): %,d ms (%2$d days %3$d hours %4$d minutes %5$d seconds)%n", age, ageDays, ageHours, ageMinutes, ageSeconds);
        String txTimeout = (String)details.get("transaction-timeout");
        stream.println("Transaction timeout (if under Tx): " + txTimeout + " sec");
        List openers = (List)details.get("openers");
        stream.println("Opener(s)'s info:");
        JDBCConnections.writeThreadInfos(stream, openers);
        List closers = (List)details.get("closers");
        if (!closers.isEmpty()) {
            stream.println("Closer(s)'s info:");
            JDBCConnections.writeThreadInfos(stream, closers);
        }
    }

    private static long getNumberOfSeconds(long duration, long fullDays, long fullHours, long fullMinutes) {
        return (duration - fullDays * 86400000L - fullHours * 3600000L - fullMinutes * 60000L) / 1000L;
    }

    private static long getNumberOfMinutes(long duration, long fullDays, long fullHours) {
        return (duration - fullDays * 86400000L - fullHours * 3600000L) / 60000L;
    }

    private static long getNumberOfHours(long duration, long fullDays) {
        return (duration - fullDays * 86400000L) / 3600000L;
    }

    private static long getNumberOfDays(long duration) {
        return duration / 86400000L;
    }

    private static void writeThreadInfos(PrintStream stream, List<Map<String, Object>> infos) {
        Iterator<Map<String, Object>> i = infos.iterator();
        while (i.hasNext()) {
            Map<String, Object> info = i.next();
            String name = (String)info.get("thread.name");
            Long time = (Long)info.get("thread.time");
            stream.format("Thread (name:%s), at %2$td/%2$tm/%2$tY %2$tH:%2$tM:%2$tS:%2$tL%n", name, new Date(time));
            String stack = (String)info.get("thread.stack");
            stream.println("Thread StackTrace:");
            stream.print(stack);
            if (!i.hasNext()) continue;
            stream.println(" - - - - - - - - - - -");
        }
    }

    public void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.outputFilePath = this.commandLine.getOptionValue("output-file", null);
        String durationFilter = this.commandLine.getOptionValue("duration-filter", "0");
        this.duration = Integer.valueOf(durationFilter);
        this.dataSourceName = this.commandLine.getOptionValue("datasource-name");
    }

    private void setOptions() {
        this.options = new Options();
        Option file = new Option("o", "output-file", true, "Print JDBC coonection infos in the given file");
        file.setRequired(false);
        file.setOptionalArg(false);
        file.setArgName("file name");
        file.setArgs(1);
        this.options.addOption(file);
        Option name = new Option("n", "datasource-name", true, "ObjectName of the DataSource to be observed");
        name.setRequired(true);
        name.setOptionalArg(false);
        this.options.addOption(name);
        Option filter = new Option("d", "duration-filter", true, "Filter Connections opened for more than <duration> (unit: seconds)");
        filter.setRequired(false);
        filter.setOptionalArg(false);
        this.options.addOption(filter);
        Option target = new Option("target", "target", true, "instances to get connection dump from");
        target.setRequired(false);
        target.setOptionalArg(true);
        target.setArgs(-2);
        target.setArgName("instances");
        this.options.addOption(target);
    }

    @Override
    public String summary() {
        return "Dumps JDBC Connections infos from a DataSource.";
    }
}

