/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.internal.notifications.AdminNotificationListener;
import org.mule.impl.internal.notifications.ComponentNotificationListener;
import org.mule.impl.internal.notifications.ConnectionNotificationListener;
import org.mule.impl.internal.notifications.CustomNotificationListener;
import org.mule.impl.internal.notifications.ManagementNotificationListener;
import org.mule.impl.internal.notifications.ManagerNotificationListener;
import org.mule.impl.internal.notifications.MessageNotificationListener;
import org.mule.impl.internal.notifications.ModelNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.impl.internal.notifications.SecurityNotificationListener;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;

public abstract class AbstractNotificationLoggerAgent
implements UMOAgent {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String name;
    private boolean ignoreManagerNotifications = false;
    private boolean ignoreModelNotifications = false;
    private boolean ignoreComponentNotifications = false;
    private boolean ignoreConnectionNotifications = false;
    private boolean ignoreSecurityNotifications = false;
    private boolean ignoreManagementNotifications = false;
    private boolean ignoreCustomNotifications = false;
    private boolean ignoreAdminNotifications = false;
    private boolean ignoreMessageNotifications = false;
    private Set listeners = new HashSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UMOServerNotificationListener listener = (UMOServerNotificationListener)iterator.next();
            MuleManager.getInstance().unregisterListener(listener);
        }
    }

    public boolean isIgnoreManagerNotifications() {
        return this.ignoreManagerNotifications;
    }

    public void setIgnoreManagerNotifications(boolean ignoreManagerNotifications) {
        this.ignoreManagerNotifications = ignoreManagerNotifications;
    }

    public boolean isIgnoreModelNotifications() {
        return this.ignoreModelNotifications;
    }

    public void setIgnoreModelNotifications(boolean ignoreModelNotifications) {
        this.ignoreModelNotifications = ignoreModelNotifications;
    }

    public boolean isIgnoreComponentNotifications() {
        return this.ignoreComponentNotifications;
    }

    public void setIgnoreComponentNotifications(boolean ignoreComponentNotifications) {
        this.ignoreComponentNotifications = ignoreComponentNotifications;
    }

    public boolean isIgnoreSecurityNotifications() {
        return this.ignoreSecurityNotifications;
    }

    public void setIgnoreSecurityNotifications(boolean ignoreSecurityNotifications) {
        this.ignoreSecurityNotifications = ignoreSecurityNotifications;
    }

    public boolean isIgnoreManagementNotifications() {
        return this.ignoreManagementNotifications;
    }

    public void setIgnoreManagementNotifications(boolean ignoreManagementNotifications) {
        this.ignoreManagementNotifications = ignoreManagementNotifications;
    }

    public boolean isIgnoreCustomNotifications() {
        return this.ignoreCustomNotifications;
    }

    public void setIgnoreCustomNotifications(boolean ignoreCustomNotifications) {
        this.ignoreCustomNotifications = ignoreCustomNotifications;
    }

    public boolean isIgnoreAdminNotifications() {
        return this.ignoreAdminNotifications;
    }

    public void setIgnoreAdminNotifications(boolean ignoreAdminNotifications) {
        this.ignoreAdminNotifications = ignoreAdminNotifications;
    }

    public boolean isIgnoreConnectionNotifications() {
        return this.ignoreConnectionNotifications;
    }

    public void setIgnoreConnectionNotifications(boolean ignoreConnectionNotifications) {
        this.ignoreConnectionNotifications = ignoreConnectionNotifications;
    }

    public final void initialise() throws InitialisationException {
        UMOServerNotificationListener l;
        this.doInitialise();
        UMOManager manager = MuleManager.getInstance();
        if (!this.ignoreManagerNotifications) {
            l = new ManagerNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                manager.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException(e, (Object)this);
            }
            this.listeners.add(l);
        }
        if (!this.ignoreModelNotifications) {
            l = new ModelNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                manager.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException(e, (Object)this);
            }
            this.listeners.add(l);
        }
        if (!this.ignoreComponentNotifications) {
            l = new ComponentNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                manager.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException(e, (Object)this);
            }
            this.listeners.add(l);
        }
        if (!this.ignoreSecurityNotifications) {
            l = new SecurityNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                manager.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException(e, (Object)this);
            }
            this.listeners.add(l);
        }
        if (!this.ignoreManagementNotifications) {
            l = new ManagementNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                manager.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException(e, (Object)this);
            }
            this.listeners.add(l);
        }
        if (!this.ignoreCustomNotifications) {
            l = new CustomNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                manager.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException(e, (Object)this);
            }
            this.listeners.add(l);
        }
        if (!this.ignoreConnectionNotifications) {
            l = new ConnectionNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                manager.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException(e, (Object)this);
            }
            this.listeners.add(l);
        }
        if (!this.ignoreAdminNotifications) {
            l = new AdminNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                manager.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException(e, (Object)this);
            }
            this.listeners.add(l);
        }
        if (!this.ignoreMessageNotifications && !MuleManager.getConfiguration().isEnableMessageEvents()) {
            this.logger.warn("EventLogger agent has been asked to log message notifications, but the MuleManager is configured not to fire Message notifications");
        } else if (!this.ignoreMessageNotifications) {
            l = new MessageNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                manager.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException(e, (Object)this);
            }
            this.listeners.add(l);
        }
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void logEvent(UMOServerNotification var1);
}

